/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.fluid.types;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidType;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class FlowingMudFluidType
extends FluidType {
    public FlowingMudFluidType() {
        super(FluidType.Properties.create().fallDistanceModifier(0.0f).canExtinguish(true).supportsBoating(true).canHydrate(true).motionScale(0.007).canConvertToSource(true).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11780_).sound(SoundActions.FLUID_VAPORIZE, SoundEvents.f_11937_));
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(){
            private static final ResourceLocation STILL = new ResourceLocation("redev:block/mud");
            private static final ResourceLocation FLOWING = new ResourceLocation("redev:block/mud_flowing");
            private static final ResourceLocation OVERLAY = new ResourceLocation("redev:textures/misc/mud_overlay.png");

            public ResourceLocation getStillTexture() {
                return STILL;
            }

            public ResourceLocation getFlowingTexture() {
                return FLOWING;
            }

            public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                return OVERLAY;
            }

            public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                return new Vector3f(0.2706f, 0.2471f, 0.2392f);
            }

            public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                RenderSystem.setShaderFogStart((float)0.0f);
                RenderSystem.setShaderFogEnd((float)2.0f);
                RenderSystem.setShaderFogShape((FogShape)FogShape.SPHERE);
            }

            public void renderOverlay(Minecraft mc, PoseStack stack) {
                ResourceLocation texture = this.getRenderOverlayTexture(mc);
                if (texture == null) {
                    return;
                }
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
                BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
                BlockPos playerEyePos = BlockPos.m_274561_((double)mc.f_91074_.m_20185_(), (double)mc.f_91074_.m_20188_(), (double)mc.f_91074_.m_20189_());
                float brightness = LightTexture.m_234316_((DimensionType)mc.f_91074_.m_9236_().m_6042_(), (int)mc.f_91074_.m_9236_().m_46803_(playerEyePos));
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.setShaderColor((float)brightness, (float)brightness, (float)brightness, (float)0.65f);
                float uOffset = -mc.f_91074_.m_146908_() / 64.0f;
                float vOffset = mc.f_91074_.m_146909_() / 64.0f;
                Matrix4f pose = stack.m_85850_().m_252922_();
                buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                buffer.m_252986_(pose, -1.0f, -1.0f, -0.5f).m_7421_(4.0f + uOffset, 4.0f + vOffset).m_5752_();
                buffer.m_252986_(pose, 1.0f, -1.0f, -0.5f).m_7421_(uOffset, 4.0f + vOffset).m_5752_();
                buffer.m_252986_(pose, 1.0f, 1.0f, -0.5f).m_7421_(uOffset, vOffset).m_5752_();
                buffer.m_252986_(pose, -1.0f, 1.0f, -0.5f).m_7421_(4.0f + uOffset, vOffset).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
                RenderSystem.disableBlend();
            }
        });
    }
}

