/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.mcreator.redev.client.model.Modelflamethrower;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class FlamethrowerItem
extends ArmorItem {
    public FlamethrowerItem(ArmorItem.Type type, Item.Properties properties) {
        super(new ArmorMaterial(){

            public int m_266425_(ArmorItem.Type type) {
                return (new int[]{13, 15, 16, 11})[type.m_266308_().m_20749_()] * 18;
            }

            public int m_7366_(ArmorItem.Type type) {
                return (new int[]{2, 5, 5, 2})[type.m_266308_().m_20749_()];
            }

            public int m_6646_() {
                return 14;
            }

            public SoundEvent m_7344_() {
                return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("item.armor.equip_netherite"));
            }

            public Ingredient m_6230_() {
                return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42419_)});
            }

            public String m_6082_() {
                return "flamethrower";
            }

            public float m_6651_() {
                return 0.5f;
            }

            public float m_6649_() {
                return 0.0f;
            }
        }, type, properties);
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT})
    public static class Chestplate
    extends FlamethrowerItem {
        private static final UUID MOVEMENT_SPEED_UUID = UUID.fromString("e7f88002-5c50-4c3a-97d7-4aeb9b0148bb");

        public Chestplate() {
            super(ArmorItem.Type.CHESTPLATE, new Item.Properties().m_41486_());
        }

        public void initializeClient(Consumer<IClientItemExtensions> consumer) {
            consumer.accept(new IClientItemExtensions(){

                @OnlyIn(value=Dist.CLIENT)
                public HumanoidModel getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel defaultModel) {
                    HumanoidModel armorModel = new HumanoidModel(new ModelPart(Collections.emptyList(), Map.of("body", new Modelflamethrower<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)Modelflamethrower.LAYER_LOCATION)).body, "left_arm", new Modelflamethrower<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)Modelflamethrower.LAYER_LOCATION)).left_arm, "right_arm", new Modelflamethrower<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)Modelflamethrower.LAYER_LOCATION)).right_arm, "head", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "hat", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()))));
                    armorModel.f_102817_ = living.m_6144_();
                    armorModel.f_102609_ = defaultModel.f_102609_;
                    armorModel.f_102610_ = living.m_6162_();
                    return armorModel;
                }
            });
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "redev:textures/entities/flamethrower.png";
        }

        public boolean makesPiglinsNeutral(ItemStack itemstack, LivingEntity entity) {
            return true;
        }

        public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
            if (equipmentSlot == EquipmentSlot.CHEST) {
                ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
                builder.putAll(super.m_7167_(equipmentSlot));
                builder.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(MOVEMENT_SPEED_UUID, "Flamethrower speed penalty", -0.1, AttributeModifier.Operation.MULTIPLY_TOTAL));
                return builder.build();
            }
            return super.m_7167_(equipmentSlot);
        }

        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
            Player player = event.player;
            if (!(player instanceof LocalPlayer)) {
                return;
            }
            ItemStack chest = player.m_6844_(EquipmentSlot.CHEST);
            if (!(chest.m_41720_() instanceof FlamethrowerItem)) {
                return;
            }
            if (!player.m_6047_() || !Chestplate.isHoldingFireCharge(player)) {
                return;
            }
            Level level = player.m_9236_();
            Vec3 eye = player.m_20299_(1.0f);
            Vec3 look = player.m_20154_();
            double spread = 0.1;
            Vec3 randomLook = look.m_82520_((player.m_217043_().m_188500_() - 0.5) * spread, (player.m_217043_().m_188500_() - 0.5) * spread, (player.m_217043_().m_188500_() - 0.5) * spread).m_82541_();
            Vec3 reach = eye.m_82549_(randomLook.m_82490_(8.0));
            BlockHitResult hit = level.m_45547_(new ClipContext(eye, reach, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
            if (hit.m_6662_() == HitResult.Type.BLOCK) {
                BlockPos center = hit.m_82425_().m_121945_(hit.m_82434_());
                for (int dx = -1; dx <= 1; ++dx) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        BlockPos pos;
                        if (dx * dx + dz * dz > 1 || !level.m_8055_(pos = center.m_7918_(dx, 0, dz)).m_247087_() || !Blocks.f_50083_.m_49966_().m_60710_((LevelReader)level, pos) || !(player.m_217043_().m_188501_() < 0.5f)) continue;
                        level.m_7731_(pos, Blocks.f_50083_.m_49966_(), 3);
                        level.m_5594_(player, pos, SoundEvents.f_11942_, SoundSource.PLAYERS, 0.6f, 1.2f);
                    }
                }
            }
            for (int i = 0; i < 6; ++i) {
                Vec3 offset = randomLook.m_82490_(0.5 + (double)i * 0.2);
                Vec3 spawn = eye.m_82549_(offset);
                Vec3 velocity = randomLook.m_82490_(0.1).m_82520_(player.m_217043_().m_188583_() * 0.02, player.m_217043_().m_188583_() * 0.02, player.m_217043_().m_188583_() * 0.02);
                level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, spawn.f_82479_, spawn.f_82480_, spawn.f_82481_, velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
            }
        }

        @SubscribeEvent
        public static void onBlockBreak(BlockEvent.BreakEvent event) {
            BlockState state;
            Player player = event.getPlayer();
            if (player.m_9236_().f_46443_) {
                return;
            }
            ItemStack chest = player.m_6844_(EquipmentSlot.CHEST);
            if (!(chest.m_41720_() instanceof FlamethrowerItem)) {
                return;
            }
            if (!Chestplate.hasFireChargeInInventory(player)) {
                return;
            }
            BlockPos pos = event.getPos();
            Level world = player.m_9236_();
            ItemStack result = Chestplate.getSmeltedResult(world, new ItemStack((ItemLike)(state = world.m_8055_(pos)).m_60734_().m_5456_()));
            if (!result.m_41619_()) {
                event.setCanceled(true);
                world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)result.m_41777_());
                Chestplate.damageChestplate(player, chest);
            }
        }

        @SubscribeEvent
        public static void onAttackEntity(AttackEntityEvent event) {
            Player player = event.getEntity();
            if (player.m_9236_().f_46443_) {
                return;
            }
            ItemStack chest = player.m_6844_(EquipmentSlot.CHEST);
            if (!(chest.m_41720_() instanceof FlamethrowerItem)) {
                return;
            }
            if (!Chestplate.hasFireChargeInInventory(player)) {
                return;
            }
            Entity entity = event.getTarget();
            if (entity instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)entity;
                target.m_20254_(4);
                Chestplate.damageChestplate(player, chest);
            }
        }

        private static boolean hasFireChargeInInventory(Player player) {
            return player.m_150109_().f_35974_.stream().anyMatch(stack -> stack.m_150930_(Items.f_42613_));
        }

        private static boolean isHoldingFireCharge(Player player) {
            return player.m_21205_().m_150930_(Items.f_42613_) || player.m_21206_().m_150930_(Items.f_42613_);
        }

        private static void damageChestplate(Player player, ItemStack chest) {
            chest.m_41622_(1, (LivingEntity)player, c -> c.m_21166_(EquipmentSlot.CHEST));
        }

        private static ItemStack getSmeltedResult(Level world, ItemStack input) {
            return world.m_7465_().m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{input}), world).map(r -> r.m_5874_((Container)new SimpleContainer(new ItemStack[]{input}), world.m_9598_())).orElse(ItemStack.f_41583_);
        }
    }
}

