/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.item;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PortalAtlasItem
extends Item {
    private static final String INDEX_KEY = "tracking_index";

    public PortalAtlasItem() {
        super(new Item.Properties().m_41487_(1).m_41486_().m_41497_(Rarity.RARE));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        int currentSlot;
        ItemStack stack = player.m_21120_(hand);
        CompoundTag tag = stack.m_41784_();
        int n = currentSlot = tag.m_128441_(INDEX_KEY) ? tag.m_128451_(INDEX_KEY) : 0;
        if (player.m_6144_()) {
            int nextSlot = (currentSlot + 1) % 5;
            tag.m_128405_(INDEX_KEY, nextSlot);
            player.m_5661_((Component)Component.m_237113_((String)("Set to slot " + nextSlot + "!")), true);
        } else {
            String currentDim;
            String keyPrefix = "tracking_" + currentSlot + "_";
            String storedDim = tag.m_128461_(keyPrefix + "dim");
            if (storedDim.equals(currentDim = level.m_46472_().m_135782_().toString())) {
                double x = tag.m_128459_(keyPrefix + "x");
                double y = tag.m_128459_(keyPrefix + "y");
                double z = tag.m_128459_(keyPrefix + "z");
                double dx = player.m_20185_() - x;
                double dy = player.m_20186_() - y;
                double dz = player.m_20189_() - z;
                double distanceSq = dx * dx + dy * dy + dz * dz;
                player.m_5661_((Component)Component.m_237113_((String)String.format("Slot %d: X: %.1f, Y: %.1f, Z: %.1f", currentSlot, dx, dy, dz)), true);
                if (!level.f_46443_ && distanceSq <= 256.0) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    int steps = 32;
                    for (int i = 0; i <= steps; ++i) {
                        double t = (double)i / (double)steps;
                        double px = player.m_20185_() + (x - player.m_20185_()) * t;
                        double py = player.m_20188_() + (y - player.m_20188_()) * t;
                        double pz = player.m_20189_() + (z - player.m_20189_()) * t;
                        double spread = 0.5;
                        double jitterX = (level.f_46441_.m_188500_() - 0.5) * spread;
                        double jitterY = (level.f_46441_.m_188500_() - 0.5) * spread;
                        double jitterZ = (level.f_46441_.m_188500_() - 0.5) * spread;
                        ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123745_, px + jitterX, py + jitterY, pz + jitterZ, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            } else {
                player.m_5661_((Component)Component.m_237113_((String)("Slot " + currentSlot + ": No data for this dimension.")), true);
            }
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    @SubscribeEvent
    public void onChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        ItemStack held;
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        ItemStack main = player2.m_21205_();
        ItemStack off = player2.m_21206_();
        ItemStack itemStack = main.m_41720_() instanceof PortalAtlasItem ? main : (held = off.m_41720_() instanceof PortalAtlasItem ? off : ItemStack.f_41583_);
        if (held.m_41619_()) {
            return;
        }
        ItemStack finalHeld = held;
        player2.m_20194_().execute(() -> {
            BlockPos pos = player2.m_20183_();
            CompoundTag tag = finalHeld.m_41784_();
            int slot = tag.m_128441_(INDEX_KEY) ? tag.m_128451_(INDEX_KEY) : 0;
            String keyPrefix = "tracking_" + slot + "_";
            tag.m_128347_(keyPrefix + "x", (double)pos.m_123341_() + 0.5);
            tag.m_128347_(keyPrefix + "y", (double)pos.m_123342_() + 0.5);
            tag.m_128347_(keyPrefix + "z", (double)pos.m_123343_() + 0.5);
            tag.m_128359_(keyPrefix + "dim", player2.m_9236_().m_46472_().m_135782_().toString());
            player2.m_5661_((Component)Component.m_237113_((String)("Slot " + slot + " set!")), true);
        });
    }
}

