/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.item;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class QuiverItem
extends Item {
    private static final String TAG_ITEMS = "Items";
    public static final int MAX_WEIGHT = 576;
    private static final int BAR_COLOR = Mth.m_14159_((float)0.89f, (float)0.2f, (float)0.2f);

    public QuiverItem() {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.COMMON));
    }

    public static boolean isArrowItem(ItemStack stack) {
        return stack.m_41720_() instanceof ArrowItem;
    }

    private static int getWeight(ItemStack stack) {
        return 1;
    }

    private static int getContentWeight(ItemStack quiver) {
        return QuiverItem.getContents(quiver).mapToInt(stack -> QuiverItem.getWeight(stack) * stack.m_41613_()).sum();
    }

    private static Stream<ItemStack> getContents(ItemStack quiver) {
        CompoundTag tag = quiver.m_41783_();
        if (tag == null || !tag.m_128441_(TAG_ITEMS)) {
            return Stream.empty();
        }
        ListTag items = tag.m_128437_(TAG_ITEMS, 10);
        return items.stream().map(CompoundTag.class::cast).map(ItemStack::m_41712_);
    }

    private static Optional<CompoundTag> getMatchingItem(ItemStack match, ListTag items) {
        return items.stream().filter(CompoundTag.class::isInstance).map(CompoundTag.class::cast).filter(nbt -> ItemStack.m_150942_((ItemStack)ItemStack.m_41712_((CompoundTag)nbt), (ItemStack)match)).findFirst();
    }

    private static int add(ItemStack quiver, ItemStack toAdd) {
        if (!QuiverItem.isArrowItem(toAdd)) {
            return 0;
        }
        CompoundTag tag = quiver.m_41784_();
        if (!tag.m_128441_(TAG_ITEMS)) {
            tag.m_128365_(TAG_ITEMS, (Tag)new ListTag());
        }
        int currentWeight = QuiverItem.getContentWeight(quiver);
        int weightPerItem = QuiverItem.getWeight(toAdd);
        int maxAddable = (576 - currentWeight) / weightPerItem;
        int toTransfer = Math.min(toAdd.m_41613_(), maxAddable);
        if (toTransfer <= 0) {
            return 0;
        }
        ListTag itemList = tag.m_128437_(TAG_ITEMS, 10);
        Optional<CompoundTag> match = QuiverItem.getMatchingItem(toAdd, itemList);
        if (match.isPresent()) {
            ItemStack existing = ItemStack.m_41712_((CompoundTag)match.get());
            int maxStack = existing.m_41741_();
            int newCount = Math.min(existing.m_41613_() + toTransfer, maxStack);
            toTransfer = newCount - existing.m_41613_();
            existing.m_41764_(newCount);
            CompoundTag updatedTag = new CompoundTag();
            existing.m_41739_(updatedTag);
            for (int i = 0; i < itemList.size(); ++i) {
                CompoundTag candidate = itemList.m_128728_(i);
                if (!ItemStack.m_150942_((ItemStack)ItemStack.m_41712_((CompoundTag)candidate), (ItemStack)toAdd)) continue;
                itemList.set(i, (Tag)updatedTag);
                break;
            }
            itemList.add(0, (Tag)updatedTag);
        } else {
            ItemStack newStack = toAdd.m_255036_(toTransfer);
            CompoundTag newTag = new CompoundTag();
            newStack.m_41739_(newTag);
            itemList.add(0, (Tag)newTag);
        }
        return toTransfer;
    }

    private static Optional<ItemStack> removeOne(ItemStack quiver) {
        CompoundTag tag = quiver.m_41784_();
        if (!tag.m_128441_(TAG_ITEMS)) {
            return Optional.empty();
        }
        ListTag list = tag.m_128437_(TAG_ITEMS, 10);
        if (list.isEmpty()) {
            return Optional.empty();
        }
        CompoundTag removedTag = list.m_128728_(0);
        list.remove(0);
        if (list.isEmpty()) {
            quiver.m_41749_(TAG_ITEMS);
        }
        return Optional.of(ItemStack.m_41712_((CompoundTag)removedTag));
    }

    private static boolean dropContents(ItemStack quiver, Player player) {
        CompoundTag tag = quiver.m_41784_();
        if (!tag.m_128441_(TAG_ITEMS)) {
            return false;
        }
        if (player instanceof ServerPlayer) {
            ListTag list = tag.m_128437_(TAG_ITEMS, 10);
            for (int i = 0; i < list.size(); ++i) {
                ItemStack arrow = ItemStack.m_41712_((CompoundTag)list.m_128728_(i));
                player.m_36176_(arrow, true);
            }
        }
        quiver.m_41749_(TAG_ITEMS);
        return true;
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        NonNullList contents = NonNullList.m_122779_();
        QuiverItem.getContents(stack).forEach(arg_0 -> contents.add(arg_0));
        return Optional.of(new BundleTooltip(contents, QuiverItem.getContentWeight(stack)));
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237113_((String)(QuiverItem.getContentWeight(stack) + "/576")).m_130940_(ChatFormatting.GRAY));
    }

    public boolean m_142522_(ItemStack stack) {
        return QuiverItem.getContentWeight(stack) > 0;
    }

    public int m_142158_(ItemStack stack) {
        return Math.min(1 + 12 * QuiverItem.getContentWeight(stack) / 576, 13);
    }

    public int m_142159_(ItemStack stack) {
        return BAR_COLOR;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack quiver = player.m_21120_(hand);
        if (QuiverItem.dropContents(quiver, player)) {
            this.playDropContentsSound((Entity)player);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19092_((Object)quiver, (boolean)level.m_5776_());
        }
        return InteractionResultHolder.m_19100_((Object)quiver);
    }

    public boolean m_142207_(ItemStack quiver, Slot slot, ClickAction action, Player player) {
        if (quiver.m_41613_() != 1 || action != ClickAction.SECONDARY) {
            return false;
        }
        ItemStack target = slot.m_7993_();
        if (target.m_41619_()) {
            this.playRemoveOneSound((Entity)player);
            QuiverItem.removeOne(quiver).ifPresent(stack -> QuiverItem.add(quiver, slot.m_150659_(stack)));
        } else if (QuiverItem.isArrowItem(target)) {
            int currentWeight = QuiverItem.getContentWeight(quiver);
            int weightPerItem = QuiverItem.getWeight(target);
            int maxAddable = (576 - currentWeight) / weightPerItem;
            int toTransfer = Math.min(target.m_41613_(), maxAddable);
            if (toTransfer > 0) {
                ItemStack taken = slot.m_150647_(toTransfer, target.m_41613_(), player);
                QuiverItem.add(quiver, taken);
                this.playInsertSound((Entity)player);
            }
        }
        return true;
    }

    public boolean m_142305_(ItemStack quiver, ItemStack stack, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (quiver.m_41613_() != 1 || action != ClickAction.SECONDARY || !slot.m_150651_(player)) {
            return false;
        }
        if (stack.m_41619_()) {
            QuiverItem.removeOne(quiver).ifPresent(s -> {
                this.playRemoveOneSound((Entity)player);
                access.m_142104_(s);
            });
        } else if (QuiverItem.isArrowItem(stack)) {
            int currentWeight = QuiverItem.getContentWeight(quiver);
            int weightPerItem = QuiverItem.getWeight(stack);
            int maxAddable = (576 - currentWeight) / weightPerItem;
            int toTransfer = Math.min(stack.m_41613_(), maxAddable);
            if (toTransfer > 0) {
                ItemStack insert = stack.m_41777_();
                insert.m_41764_(toTransfer);
                QuiverItem.add(quiver, insert);
                stack.m_41774_(toTransfer);
                this.playInsertSound((Entity)player);
            }
        }
        return true;
    }

    private void playInsertSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184215_, 0.8f, 0.9f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private void playRemoveOneSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184216_, 0.8f, 0.9f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private void playDropContentsSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184214_, 0.8f, 0.9f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    public void m_142023_(ItemEntity itemEntity) {
        ItemUtils.m_150952_((ItemEntity)itemEntity, QuiverItem.getContents(itemEntity.m_32055_()));
    }
}

