/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.item;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class SackOBlocksItem
extends Item {
    private static final String TAG_ITEMS = "Items";
    public static final int MAX_WEIGHT = 320;
    private static final int BAR_COLOR = Mth.m_14159_((float)0.204f, (float)0.89f, (float)0.286f);

    public SackOBlocksItem() {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.COMMON));
    }

    public static boolean isBlockItem(ItemStack stack) {
        return stack.m_41720_() instanceof BlockItem;
    }

    private static int getWeight(ItemStack stack) {
        return 1;
    }

    private static int getContentWeight(ItemStack quiver) {
        return SackOBlocksItem.getContents(quiver).mapToInt(stack -> SackOBlocksItem.getWeight(stack) * stack.m_41613_()).sum();
    }

    private static Stream<ItemStack> getContents(ItemStack quiver) {
        CompoundTag tag = quiver.m_41783_();
        if (tag == null || !tag.m_128441_(TAG_ITEMS)) {
            return Stream.empty();
        }
        ListTag items = tag.m_128437_(TAG_ITEMS, 10);
        return items.stream().map(CompoundTag.class::cast).map(ItemStack::m_41712_);
    }

    private static Optional<CompoundTag> getMatchingItem(ItemStack match, ListTag items) {
        return items.stream().filter(CompoundTag.class::isInstance).map(CompoundTag.class::cast).filter(nbt -> ItemStack.m_150942_((ItemStack)ItemStack.m_41712_((CompoundTag)nbt), (ItemStack)match)).findFirst();
    }

    private static int add(ItemStack quiver, ItemStack toAdd) {
        if (!SackOBlocksItem.isBlockItem(toAdd)) {
            return 0;
        }
        CompoundTag tag = quiver.m_41784_();
        if (!tag.m_128441_(TAG_ITEMS)) {
            tag.m_128365_(TAG_ITEMS, (Tag)new ListTag());
        }
        ListTag itemList = tag.m_128437_(TAG_ITEMS, 10);
        int currentWeight = SackOBlocksItem.getContentWeight(quiver);
        int weightPerItem = SackOBlocksItem.getWeight(toAdd);
        int maxAddable = (320 - currentWeight) / weightPerItem;
        int toTransfer = Math.min(toAdd.m_41613_(), maxAddable);
        if (toTransfer <= 0) {
            return 0;
        }
        int remainingToAdd = toTransfer;
        for (int i = 0; i < itemList.size() && remainingToAdd > 0; ++i) {
            int maxStack;
            int spaceLeft;
            CompoundTag tagItem = itemList.m_128728_(i);
            ItemStack existing = ItemStack.m_41712_((CompoundTag)tagItem);
            if (!ItemStack.m_150942_((ItemStack)existing, (ItemStack)toAdd) || (spaceLeft = (maxStack = existing.m_41741_()) - existing.m_41613_()) <= 0) continue;
            int adding = Math.min(spaceLeft, remainingToAdd);
            existing.m_41769_(adding);
            remainingToAdd -= adding;
            CompoundTag updatedTag = new CompoundTag();
            existing.m_41739_(updatedTag);
            itemList.set(i, (Tag)updatedTag);
        }
        while (remainingToAdd > 0) {
            int batch = Math.min(toAdd.m_41741_(), remainingToAdd);
            ItemStack newStack = toAdd.m_41777_();
            newStack.m_41764_(batch);
            CompoundTag newTag = new CompoundTag();
            newStack.m_41739_(newTag);
            itemList.add(0, (Tag)newTag);
            remainingToAdd -= batch;
        }
        tag.m_128365_(TAG_ITEMS, (Tag)itemList);
        quiver.m_41751_(tag);
        toAdd.m_41774_(toTransfer);
        return toTransfer;
    }

    private static Optional<ItemStack> removeOne(ItemStack quiver) {
        CompoundTag tag = quiver.m_41784_();
        if (!tag.m_128441_(TAG_ITEMS)) {
            return Optional.empty();
        }
        ListTag list = tag.m_128437_(TAG_ITEMS, 10);
        if (list.isEmpty()) {
            return Optional.empty();
        }
        CompoundTag removedTag = list.m_128728_(0);
        list.remove(0);
        if (list.isEmpty()) {
            quiver.m_41749_(TAG_ITEMS);
        } else {
            tag.m_128365_(TAG_ITEMS, (Tag)list);
        }
        quiver.m_41751_(tag);
        return Optional.of(ItemStack.m_41712_((CompoundTag)removedTag));
    }

    private static boolean dropContents(ItemStack quiver, Player player) {
        CompoundTag tag = quiver.m_41784_();
        if (!tag.m_128441_(TAG_ITEMS)) {
            return false;
        }
        if (player instanceof ServerPlayer) {
            ListTag list = tag.m_128437_(TAG_ITEMS, 10);
            for (int i = 0; i < list.size(); ++i) {
                ItemStack arrow = ItemStack.m_41712_((CompoundTag)list.m_128728_(i));
                player.m_36176_(arrow, true);
            }
        }
        quiver.m_41749_(TAG_ITEMS);
        return true;
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        NonNullList contents = NonNullList.m_122779_();
        SackOBlocksItem.getContents(stack).forEach(arg_0 -> contents.add(arg_0));
        return Optional.of(new BundleTooltip(contents, SackOBlocksItem.getContentWeight(stack)));
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237113_((String)(SackOBlocksItem.getContentWeight(stack) + "/320")).m_130940_(ChatFormatting.GRAY));
    }

    public boolean m_142522_(ItemStack stack) {
        return SackOBlocksItem.getContentWeight(stack) > 0;
    }

    public int m_142158_(ItemStack stack) {
        return Math.min(1 + 12 * SackOBlocksItem.getContentWeight(stack) / 320, 13);
    }

    public int m_142159_(ItemStack stack) {
        return BAR_COLOR;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack quiver = player.m_21120_(hand);
        if (player.m_6144_() && SackOBlocksItem.dropContents(quiver, player)) {
            this.playDropContentsSound((Entity)player);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19092_((Object)quiver, (boolean)level.m_5776_());
        }
        return InteractionResultHolder.m_19098_((Object)quiver);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        if (level.f_46443_) {
            return InteractionResult.PASS;
        }
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        ItemStack sack = context.m_43722_();
        List<ItemStack> candidates = SackOBlocksItem.getContents(sack).filter(stack -> stack.m_41720_() instanceof BlockItem).toList();
        if (candidates.isEmpty()) {
            return InteractionResult.PASS;
        }
        int chosenIndex = level.f_46441_.m_188503_(candidates.size());
        ItemStack storedStack = candidates.get(chosenIndex);
        final ItemStack toPlace = storedStack.m_41777_();
        toPlace.m_41764_(1);
        BlockItem blockItem = (BlockItem)toPlace.m_41720_();
        BlockPlaceContext placementContext = new BlockPlaceContext(context){

            public ItemStack m_43722_() {
                return toPlace;
            }
        };
        InteractionResult result = blockItem.m_40576_(placementContext);
        if (result.m_19077_()) {
            SackOBlocksItem.removeOneOf(sack, storedStack);
            level.m_5594_(null, context.m_8083_(), SoundEvents.f_184216_, SoundSource.PLAYERS, 0.8f, 1.0f);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private static void removeOneOf(ItemStack container, ItemStack match) {
        CompoundTag tag = container.m_41784_();
        if (!tag.m_128441_(TAG_ITEMS)) {
            return;
        }
        ListTag list = tag.m_128437_(TAG_ITEMS, 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag candidate = list.m_128728_(i);
            ItemStack item = ItemStack.m_41712_((CompoundTag)candidate);
            if (!ItemStack.m_150942_((ItemStack)item, (ItemStack)match)) continue;
            item.m_41774_(1);
            if (item.m_41619_()) {
                list.remove(i);
            } else {
                CompoundTag updated = new CompoundTag();
                item.m_41739_(updated);
                list.set(i, (Tag)updated);
            }
            if (list.isEmpty()) {
                container.m_41749_(TAG_ITEMS);
            } else {
                tag.m_128365_(TAG_ITEMS, (Tag)list);
            }
            container.m_41751_(tag);
            return;
        }
    }

    public boolean m_142207_(ItemStack quiver, Slot slot, ClickAction action, Player player) {
        if (quiver.m_41613_() != 1 || action != ClickAction.SECONDARY) {
            return false;
        }
        ItemStack target = slot.m_7993_();
        if (target.m_41619_()) {
            this.playRemoveOneSound((Entity)player);
            SackOBlocksItem.removeOne(quiver).ifPresent(stack -> SackOBlocksItem.add(quiver, slot.m_150659_(stack)));
        } else if (SackOBlocksItem.isBlockItem(target)) {
            int currentWeight = SackOBlocksItem.getContentWeight(quiver);
            int weightPerItem = SackOBlocksItem.getWeight(target);
            int maxAddable = (320 - currentWeight) / weightPerItem;
            int toTransfer = Math.min(target.m_41613_(), maxAddable);
            if (toTransfer > 0) {
                ItemStack taken = slot.m_150647_(toTransfer, target.m_41613_(), player);
                SackOBlocksItem.add(quiver, taken);
                this.playInsertSound((Entity)player);
            }
        }
        return true;
    }

    public boolean m_142305_(ItemStack quiver, ItemStack stack, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (quiver.m_41613_() != 1 || action != ClickAction.SECONDARY || !slot.m_150651_(player)) {
            return false;
        }
        if (stack.m_41619_()) {
            SackOBlocksItem.removeOne(quiver).ifPresent(s -> {
                this.playRemoveOneSound((Entity)player);
                access.m_142104_(s);
            });
        } else if (SackOBlocksItem.isBlockItem(stack)) {
            int currentWeight = SackOBlocksItem.getContentWeight(quiver);
            int weightPerItem = SackOBlocksItem.getWeight(stack);
            int maxAddable = (320 - currentWeight) / weightPerItem;
            int toTransfer = Math.min(stack.m_41613_(), maxAddable);
            if (toTransfer > 0) {
                ItemStack insert = stack.m_41777_();
                insert.m_41764_(toTransfer);
                SackOBlocksItem.add(quiver, insert);
                stack.m_41774_(toTransfer);
                this.playInsertSound((Entity)player);
            }
        }
        return true;
    }

    private void playInsertSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184215_, 0.8f, 0.9f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private void playRemoveOneSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184216_, 0.8f, 0.9f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private void playDropContentsSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184214_, 0.8f, 0.9f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    public void m_142023_(ItemEntity itemEntity) {
        ItemUtils.m_150952_((ItemEntity)itemEntity, SackOBlocksItem.getContents(itemEntity.m_32055_()));
    }
}

