/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class SwiftItem
extends ArmorItem {
    public static final UUID SPEED_BOOST_UUID = UUID.fromString("d3b6e211-5c1d-4b63-9f3d-abc123def456");
    private static final WeakHashMap<LivingEntity, Integer> sprintTicks = new WeakHashMap();

    public SwiftItem(ArmorItem.Type type, Item.Properties properties) {
        super(new ArmorMaterial(){

            public int m_266425_(ArmorItem.Type type) {
                return (new int[]{13, 15, 16, 11})[type.m_266308_().m_20749_()] * 10;
            }

            public int m_7366_(ArmorItem.Type type) {
                return (new int[]{1, 0, 0, 0})[type.m_266308_().m_20749_()];
            }

            public int m_6646_() {
                return 9;
            }

            public SoundEvent m_7344_() {
                return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("item.armor.equip_leather"));
            }

            public Ingredient m_6230_() {
                return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42534_)});
            }

            public String m_6082_() {
                return "swift";
            }

            public float m_6651_() {
                return 0.0f;
            }

            public float m_6649_() {
                return 0.0f;
            }
        }, type, properties);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        if (level.f_46443_ || !(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        ItemStack boots = living.m_6844_(EquipmentSlot.FEET);
        boolean isWearingSwift = boots.m_41720_() instanceof SwiftItem;
        AttributeInstance attr = living.m_21051_(Attributes.f_22279_);
        if (attr == null) {
            return;
        }
        boolean hasBoost = attr.m_22122_().stream().anyMatch(mod -> mod.m_22209_().equals(SPEED_BOOST_UUID));
        if (isWearingSwift && living.m_20142_()) {
            int ticks = sprintTicks.getOrDefault(living, 0) + 1;
            sprintTicks.put(living, ticks);
            float percent = Math.min(0.5f, 0.5f * ((float)ticks / 80.0f));
            if (hasBoost) {
                attr.m_22120_(SPEED_BOOST_UUID);
            }
            attr.m_22118_(new AttributeModifier(SPEED_BOOST_UUID, "Swift Boots Scaling Speed", (double)percent, AttributeModifier.Operation.MULTIPLY_TOTAL));
            if (living.m_20096_()) {
                double lift = (double)percent * 0.125;
                Vec3 motion = living.m_20184_();
                living.m_20334_(motion.f_82479_, Math.max(motion.f_82480_, lift), motion.f_82481_);
            }
            living.m_20242_(percent >= 0.5f);
        } else {
            sprintTicks.remove(living);
            if (hasBoost) {
                attr.m_22120_(SPEED_BOOST_UUID);
            }
            living.m_20242_(false);
        }
    }

    public static class Boots
    extends SwiftItem {
        private static final UUID MOVEMENT_SPEED_UUID = UUID.fromString("e7f88002-5c50-4c3a-97d7-4aeb9b0148bb");

        public Boots() {
            super(ArmorItem.Type.BOOTS, new Item.Properties());
        }

        public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
            if (equipmentSlot == EquipmentSlot.FEET) {
                ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
                builder.putAll(super.m_7167_(equipmentSlot));
                builder.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(MOVEMENT_SPEED_UUID, "Swift speed bonus", 0.1, AttributeModifier.Operation.MULTIPLY_TOTAL));
                return builder.build();
            }
            return super.m_7167_(equipmentSlot);
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "redev:textures/models/armor/swift_boots__layer_1.png";
        }
    }
}

