/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.potion;

import java.util.UUID;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class FrostVesselMobEffect
extends MobEffect {
    private static final UUID MODIFIER_UUID = UUID.fromString("e1aaf9e1-b5b3-432c-a9c9-4c4882b6f8d3");
    private static final AttributeModifier SPEED_BOOST_MODIFIER = new AttributeModifier(MODIFIER_UUID, "FrostVesselSpeedBoost", 0.3, AttributeModifier.Operation.MULTIPLY_TOTAL);

    public FrostVesselMobEffect() {
        super(MobEffectCategory.BENEFICIAL, -10976295);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        Player player;
        if (entity instanceof Player && (player = (Player)entity).m_20159_()) {
            Entity vehicle = player.m_20202_();
            if (vehicle instanceof Mob) {
                Mob mount = (Mob)vehicle;
                AttributeInstance attribute = mount.m_21051_(Attributes.f_22279_);
                if (attribute != null && !attribute.m_22109_(SPEED_BOOST_MODIFIER)) {
                    attribute.m_22118_(this.getModifier(1.3 + 0.3 * (double)amplifier));
                }
            } else if (vehicle instanceof Boat) {
                Vec3 currentMotion = vehicle.m_20184_();
                double speedMultiplier = 1.15 + 0.15 * (double)amplifier;
                double horizontalSpeed = currentMotion.m_165924_();
                double clampedSpeed = Math.min(horizontalSpeed * speedMultiplier, 1.0);
                Vec3 newMotion = currentMotion.m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_(clampedSpeed).m_82520_(0.0, currentMotion.f_82480_, 0.0);
                vehicle.m_20256_(newMotion);
            } else if (vehicle instanceof Minecart) {
                Vec3 currentMotion = vehicle.m_20184_();
                double speedMultiplier = 1.15 + 0.15 * (double)amplifier;
                double clampedSpeed = Math.min(currentMotion.m_165924_() * speedMultiplier, 0.6);
                vehicle.m_20256_(currentMotion.m_82541_().m_82490_(clampedSpeed));
            }
        }
    }

    public void m_6386_(LivingEntity entity, AttributeMap attributeMap, int amplifier) {
        Mob mount;
        AttributeInstance attribute;
        Entity vehicle;
        Player player;
        if (entity instanceof Player && (player = (Player)entity).m_20159_() && (vehicle = player.m_20202_()) instanceof Mob && (attribute = (mount = (Mob)vehicle).m_21051_(Attributes.f_22279_)) != null) {
            attribute.m_22120_(MODIFIER_UUID);
        }
        super.m_6386_(entity, attributeMap, amplifier);
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }

    private AttributeModifier getModifier(double speedMultiplier) {
        return new AttributeModifier(MODIFIER_UUID, "FrostVesselSpeedBoost", speedMultiplier - 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
    }

    @SubscribeEvent
    public void onDismount(EntityMountEvent event) {
        Entity entity;
        if (event.isDismounting() && (entity = event.getEntity()) instanceof Player) {
            Mob mount;
            AttributeInstance attribute;
            Player player = (Player)entity;
            Entity vehicle = event.getEntityBeingMounted();
            if (vehicle instanceof Mob && (attribute = (mount = (Mob)vehicle).m_21051_(Attributes.f_22279_)) != null && attribute.m_22109_(SPEED_BOOST_MODIFIER)) {
                attribute.m_22130_(SPEED_BOOST_MODIFIER);
            }
        }
    }
}

