/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.world.feature.trunkplacer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.mcreator.redev.init.RedevModTrunkTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class SquareTrunkPlacer
extends TrunkPlacer {
    public static final Codec<SquareTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> SquareTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)instance).and((App)Codec.INT.fieldOf("branch_count").forGetter(placer -> placer.branchCount)).and((App)Codec.BOOL.fieldOf("sponge_trunk").forGetter(placer -> placer.spongeTrunk)).apply((Applicative)instance, SquareTrunkPlacer::new));
    private final int branchCount;
    private final boolean spongeTrunk;

    public SquareTrunkPlacer(int baseHeight, int heightRandA, int heightRandB, int branchCount, boolean spongeTrunk) {
        super(baseHeight, heightRandA, heightRandB);
        this.branchCount = branchCount;
        this.spongeTrunk = spongeTrunk;
    }

    protected TrunkPlacerType<?> m_7362_() {
        return (TrunkPlacerType)RedevModTrunkTypes.SQUARE_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> m_213934_(LevelSimulatedReader reader, BiConsumer<BlockPos, BlockState> trunkConsumer, RandomSource random, int height, BlockPos pos, TreeConfiguration config) {
        for (int y = 0; y < height; ++y) {
            for (int dx = -2; dx <= 1; ++dx) {
                for (int dz = -2; dz <= 1; ++dz) {
                    if (!(y != height - 1 || dx != -2 && dx != 1 || dz != -2 && dz != 1)) continue;
                    BlockPos trunkPos = pos.m_7918_(dx, y, dz);
                    if (this.spongeTrunk && this.isInsideTrunk(pos, trunkPos) && random.m_188501_() < 0.1f) {
                        trunkConsumer.accept(trunkPos, Blocks.f_49990_.m_49966_());
                        continue;
                    }
                    this.m_226187_(reader, trunkConsumer, random, trunkPos, config);
                }
            }
        }
        ArrayList<FoliagePlacer.FoliageAttachment> foliageAttachments = new ArrayList<FoliagePlacer.FoliageAttachment>();
        this.generateBranches(reader, trunkConsumer, random, height, pos, config, foliageAttachments);
        this.generateRoots(reader, trunkConsumer, random, pos, config);
        return foliageAttachments;
    }

    private void generateBranches(LevelSimulatedReader reader, BiConsumer<BlockPos, BlockState> trunkConsumer, RandomSource random, int height, BlockPos pos, TreeConfiguration config, List<FoliagePlacer.FoliageAttachment> foliageAttachments) {
        int minBranchY = 3;
        int maxBranchY = height - 2;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos branchStart;
            int branchY = random.m_188503_(maxBranchY - minBranchY + 1) + minBranchY;
            BlockPos currentBranchPos = branchStart = (switch (direction) {
                case Direction.NORTH -> pos.m_7918_(0, branchY, -2);
                case Direction.SOUTH -> pos.m_7918_(0, branchY, 1);
                case Direction.WEST -> pos.m_7918_(-2, branchY, 0);
                case Direction.EAST -> pos.m_7918_(1, branchY, 0);
                default -> pos;
            });
            int branchLength = random.m_188503_(2) + 4;
            for (int j = 0; j < branchLength && !this.isInsideTrunk(pos, currentBranchPos = currentBranchPos.m_121945_(direction)); ++j) {
                this.m_226187_(reader, trunkConsumer, random, currentBranchPos, config);
            }
            int verticalLogs = random.m_188503_(2) + 1;
            BlockPos branchEnd = currentBranchPos;
            for (int v = 0; v < verticalLogs; ++v) {
                branchEnd = branchEnd.m_7494_();
                this.m_226187_(reader, trunkConsumer, random, branchEnd, config);
            }
            foliageAttachments.add(new FoliagePlacer.FoliageAttachment(branchEnd.m_7494_(), 0, false));
        }
    }

    private void generateRoots(LevelSimulatedReader reader, BiConsumer<BlockPos, BlockState> trunkConsumer, RandomSource random, BlockPos pos, TreeConfiguration config) {
        ArrayList<Direction> directions = new ArrayList<Direction>(List.of(Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST));
        int rootCount = random.m_188503_(3) + 1;
        block0: for (int i = 0; i < rootCount; ++i) {
            Direction rootDirection = (Direction)directions.remove(random.m_188503_(directions.size()));
            int rootY = random.m_188499_() ? 0 : 1;
            BlockPos rootStart = pos.m_7918_(rootDirection.m_122429_() * 2, rootY, rootDirection.m_122431_() * 2);
            int grassLayerCount = 0;
            int dirtLayerCount = 0;
            int rootDepth = random.m_188503_(3) + 2;
            BlockPos currentRootPos = rootStart;
            for (int j = 0; j < rootDepth; ++j) {
                if (reader.m_7433_(currentRootPos = currentRootPos.m_7495_(), state -> state.m_60713_(Blocks.f_50440_))) {
                    if (grassLayerCount >= true) continue block0;
                    ++grassLayerCount;
                    trunkConsumer.accept(currentRootPos, config.f_68185_.m_213972_(random, currentRootPos));
                    continue;
                }
                if (reader.m_7433_(currentRootPos, state -> state.m_60713_(Blocks.f_50493_))) {
                    if (dirtLayerCount >= true) continue block0;
                    ++dirtLayerCount;
                    trunkConsumer.accept(currentRootPos, config.f_68185_.m_213972_(random, currentRootPos));
                    continue;
                }
                if (!reader.m_7433_(currentRootPos, state -> state.m_60795_())) continue block0;
                trunkConsumer.accept(currentRootPos, config.f_68185_.m_213972_(random, currentRootPos));
            }
        }
    }

    private boolean isInsideTrunk(BlockPos trunkCenter, BlockPos pos) {
        int dx = pos.m_123341_() - trunkCenter.m_123341_();
        int dz = pos.m_123343_() - trunkCenter.m_123343_();
        return dx >= -1 && dx <= 0 && dz >= -1 && dz <= 0;
    }
}

