/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.block;

import net.mcreator.redev.block.entity.KeyholeBlockBlockEntity;
import net.mcreator.redev.init.RedevModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.registries.ForgeRegistries;

public class KeyholeBlockBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = DirectionalBlock.f_52588_;
    public static final IntegerProperty POWER = IntegerProperty.m_61631_((String)"power", (int)0, (int)15);

    public KeyholeBlockBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_280658_(NoteBlockInstrument.BASEDRUM).m_60918_(SoundType.f_56742_).m_60913_(1.0f, 3.0f).m_60999_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWER, (Comparable)Integer.valueOf(0)));
    }

    public int m_7753_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 15;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, POWER});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_7820_().m_122424_());
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public int m_6378_(BlockState blockstate, BlockGetter blockAccess, BlockPos pos, Direction direction) {
        return (Integer)blockstate.m_61143_((Property)POWER);
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return true;
    }

    public MenuProvider m_7246_(BlockState state, Level worldIn, BlockPos pos) {
        MenuProvider menuProvider;
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        return tileEntity instanceof MenuProvider ? (menuProvider = (MenuProvider)tileEntity) : null;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemStack = player.m_21120_(hand);
        Item item = itemStack.m_41720_();
        if (item == ((Block)RedevModBlocks.KEY_GOLEM_BLOCK.get()).m_5456_()) {
            this.activateRedstone(world, pos);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private void activateRedstone(Level world, BlockPos pos) {
        world.m_7731_(pos, (BlockState)world.m_8055_(pos).m_61124_((Property)POWER, (Comparable)Integer.valueOf(7)), 3);
        this.playUnlockSound(world, pos);
        world.m_186460_(pos, (Block)this, 20);
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if ((Integer)state.m_61143_((Property)POWER) > 0) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)POWER, (Comparable)Integer.valueOf(0)), 3);
            this.playLockSound((Level)world, pos);
        }
    }

    private void playUnlockSound(Level world, BlockPos pos) {
        SoundEvent unlockSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("minecraft:block.iron_door.open"));
        SoundEvent happySound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("redev:key_golem.happy"));
        if (unlockSound != null) {
            world.m_5594_(null, pos, unlockSound, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        if (happySound != null) {
            world.m_5594_(null, pos, happySound, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private void playLockSound(Level world, BlockPos pos) {
        SoundEvent lockSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("minecraft:block.iron_door.close"));
        if (lockSound != null) {
            world.m_5594_(null, pos, lockSound, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new KeyholeBlockBlockEntity(pos, state);
    }

    public boolean m_8133_(BlockState state, Level world, BlockPos pos, int eventID, int eventParam) {
        super.m_8133_(state, world, pos, eventID, eventParam);
        BlockEntity blockEntity = world.m_7702_(pos);
        return blockEntity != null && blockEntity.m_7531_(eventID, eventParam);
    }
}

