/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.block;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Vector3f;

public class MagneticCoreBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final EnumProperty<MagnetState> STATE = EnumProperty.m_61587_((String)"state", MagnetState.class);
    public static final IntegerProperty RADIUS = IntegerProperty.m_61631_((String)"radius", (int)1, (int)8);
    public static final IntegerProperty STRENGTH = IntegerProperty.m_61631_((String)"strength", (int)1, (int)10);

    public MagneticCoreBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56743_).m_60913_(7.0f, 8.0f).m_60999_().m_60955_().m_60924_((bs, br, bp) -> false));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_(STATE, (Comparable)((Object)MagnetState.DORMANT))).m_61124_((Property)RADIUS, (Comparable)Integer.valueOf(6))).m_61124_((Property)STRENGTH, (Comparable)Integer.valueOf(5)));
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return state.m_60819_().m_76178_();
    }

    public int m_7753_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return MagneticCoreBlock.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, POWERED, STATE, RADIUS, STRENGTH});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        boolean flag = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return super.m_7417_(state, facing, facingState, world, currentPos, facingPos);
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return true;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (level.f_46443_) {
            return;
        }
        boolean poweredNow = level.m_276867_(pos);
        boolean wasPowered = (Boolean)state.m_61143_((Property)POWERED);
        if (poweredNow && !wasPowered) {
            MagnetState newState = switch ((MagnetState)((Object)state.m_61143_(STATE))) {
                default -> throw new IncompatibleClassChangeError();
                case MagnetState.DORMANT -> MagnetState.ATTRACT;
                case MagnetState.ATTRACT -> MagnetState.REPEL;
                case MagnetState.REPEL -> MagnetState.DORMANT;
            };
            BlockState updated = (BlockState)((BlockState)state.m_61124_(STATE, (Comparable)((Object)newState))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true));
            level.m_7731_(pos, updated, 2);
            this.spawnToggleParticles(level, pos, newState);
            if (newState != MagnetState.DORMANT) {
                level.m_186460_(pos, (Block)this, 2);
            }
        } else if (!poweredNow && wasPowered) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        MagnetState mode = (MagnetState)((Object)state.m_61143_(STATE));
        if (mode == MagnetState.DORMANT) {
            return;
        }
        int radius = (Integer)state.m_61143_((Property)RADIUS);
        double strength = (double)((Integer)state.m_61143_((Property)STRENGTH)).intValue() * 0.03;
        Vec3 center = Vec3.m_82512_((Vec3i)pos);
        List items = level.m_45976_(LivingEntity.class, new AABB(pos).m_82400_((double)radius));
        for (LivingEntity item : items) {
            Vec3 dir = center.m_82546_(item.m_20182_()).m_82541_();
            Vec3 motion = switch (mode) {
                case MagnetState.ATTRACT -> dir.m_82490_(strength);
                case MagnetState.REPEL -> dir.m_82490_(-strength);
                default -> Vec3.f_82478_;
            };
            item.m_20256_(item.m_20184_().m_82549_(motion));
            item.f_19812_ = true;
        }
        level.m_186460_(pos, (Block)this, 2);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        int current;
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        ItemStack held = player.m_21120_(hand);
        BlockState newState = state;
        if (held.m_150930_(Items.f_42416_)) {
            int current2 = (Integer)state.m_61143_((Property)RADIUS);
            if (current2 < 12) {
                newState = (BlockState)state.m_61124_((Property)RADIUS, (Comparable)Integer.valueOf(current2 + 1));
                player.m_5661_((Component)Component.m_237113_((String)("Magnet radius increased to " + (current2 + 1))), true);
                level.m_5594_(null, pos, SoundEvents.f_12009_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        } else if (held.m_150930_(Items.f_41863_)) {
            int current3 = (Integer)state.m_61143_((Property)RADIUS);
            if (current3 > 1) {
                newState = (BlockState)state.m_61124_((Property)RADIUS, (Comparable)Integer.valueOf(current3 - 1));
                player.m_5661_((Component)Component.m_237113_((String)("Magnet radius decreased to " + (current3 - 1))), true);
                level.m_5594_(null, pos, SoundEvents.f_12009_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        } else if (held.m_150930_(Items.f_42451_)) {
            int current4 = (Integer)state.m_61143_((Property)STRENGTH);
            if (current4 < 10) {
                newState = (BlockState)state.m_61124_((Property)STRENGTH, (Comparable)Integer.valueOf(current4 + 1));
                player.m_5661_((Component)Component.m_237113_((String)("Magnet strength increased to " + (current4 + 1))), true);
                level.m_5594_(null, pos, SoundEvents.f_12009_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        } else if (held.m_150930_(Items.f_41830_) && (current = ((Integer)state.m_61143_((Property)STRENGTH)).intValue()) > 1) {
            newState = (BlockState)state.m_61124_((Property)STRENGTH, (Comparable)Integer.valueOf(current - 1));
            player.m_5661_((Component)Component.m_237113_((String)("Magnet strength decreased to " + (current - 1))), true);
            level.m_5594_(null, pos, SoundEvents.f_12009_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        if (newState != state) {
            level.m_7731_(pos, newState, 2);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private void spawnToggleParticles(Level level, BlockPos pos, MagnetState state) {
        Vector3f colorEnd;
        Vector3f colorStart;
        if (level.f_46443_) {
            return;
        }
        switch (state) {
            case ATTRACT: {
                colorStart = new Vector3f(0.4f, 0.4f, 0.4f);
                colorEnd = new Vector3f(1.0f, 0.0f, 0.0f);
                break;
            }
            case REPEL: {
                colorStart = new Vector3f(1.0f, 0.0f, 0.0f);
                colorEnd = new Vector3f(0.0f, 0.5f, 1.0f);
                break;
            }
            default: {
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    BlockState breakState = this.m_49966_();
                    BlockParticleOption breakParticle = new BlockParticleOption(ParticleTypes.f_123794_, breakState);
                    serverLevel.m_8767_((ParticleOptions)breakParticle, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 16, 0.3, 0.3, 0.3, 0.1);
                }
                return;
            }
        }
        DustColorTransitionOptions dust = new DustColorTransitionOptions(colorStart, colorEnd, 1.0f);
        double px = (double)pos.m_123341_() + 0.5;
        double py = (double)pos.m_123342_() + 0.5;
        double pz = (double)pos.m_123343_() + 0.5;
        for (int i = 0; i < 16; ++i) {
            double dx = level.f_46441_.m_188583_() * 0.1;
            double dy = level.f_46441_.m_188583_() * 0.1;
            double dz = level.f_46441_.m_188583_() * 0.1;
            ((ServerLevel)level).m_8767_((ParticleOptions)dust, px, py, pz, 1, dx, dy, dz, 0.0);
        }
    }

    public static enum MagnetState implements StringRepresentable
    {
        DORMANT("dormant"),
        ATTRACT("attract"),
        REPEL("repel");

        private final String name;

        private MagnetState(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

