/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;

public class NurturingTotemBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final IntegerProperty CHARGES = IntegerProperty.m_61631_((String)"charges", (int)0, (int)3);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public NurturingTotemBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_278183_().m_280658_(NoteBlockInstrument.BASS).m_60918_(SoundType.f_56736_).m_60978_(1.0f).m_60955_().m_278166_(PushReaction.BLOCK).m_60924_((bs, br, bp) -> false));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)CHARGES, (Comparable)Integer.valueOf(3))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int m_7753_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        int charges = (Integer)state.m_61143_((Property)CHARGES);
        if (charges > 0) {
            level.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < 8; ++i) {
                    double offsetX = (double)pos.m_123341_() + 0.5 + (level.f_46441_.m_188500_() - 0.5) * 1.2;
                    double offsetY = (double)pos.m_123342_() + 0.3 + level.f_46441_.m_188500_() * 1.0;
                    double offsetZ = (double)pos.m_123343_() + 0.5 + (level.f_46441_.m_188500_() - 0.5) * 1.2;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123750_, offsetX, offsetY, offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
            AreaEffectCloud cloud = new AreaEffectCloud(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
            cloud.m_19712_(2.0f);
            cloud.m_19734_(600);
            cloud.m_19714_(0xFF0505);
            cloud.m_19716_(new MobEffectInstance(MobEffects.f_19605_, 600, 0));
            level.m_7967_((Entity)cloud);
            player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 1200, 1));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19616_, 300, 0));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 700, 0));
            level.m_5594_(null, pos, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("redev:item.totemofnurturing.use")), SoundSource.PLAYERS, 1.0f, 1.0f);
            if (--charges <= 0) {
                level.m_7471_(pos, false);
            } else {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)CHARGES, (Comparable)Integer.valueOf(charges)), 3);
            }
        }
        return InteractionResult.CONSUME;
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            default -> Shapes.m_83110_((VoxelShape)NurturingTotemBlock.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)17.0, (double)11.0), (VoxelShape)NurturingTotemBlock.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)17.0, (double)11.0));
            case Direction.NORTH -> Shapes.m_83110_((VoxelShape)NurturingTotemBlock.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)17.0, (double)11.0), (VoxelShape)NurturingTotemBlock.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)17.0, (double)11.0));
            case Direction.EAST -> Shapes.m_83110_((VoxelShape)NurturingTotemBlock.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)17.0, (double)11.0), (VoxelShape)NurturingTotemBlock.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)17.0, (double)11.0));
            case Direction.WEST -> Shapes.m_83110_((VoxelShape)NurturingTotemBlock.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)17.0, (double)11.0), (VoxelShape)NurturingTotemBlock.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)17.0, (double)11.0));
        };
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return super.m_7417_(state, facing, facingState, world, currentPos, facingPos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, CHARGES, WATERLOGGED});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        boolean water = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)CHARGES, (Comparable)Integer.valueOf(3))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(water));
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }
}

