/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.block.entity;

import java.util.ArrayList;
import java.util.List;
import net.mcreator.redev.init.RedevModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TeapotBlockEntity
extends BlockEntity {
    private final List<MobEffectInstance> storedEffects = new ArrayList<MobEffectInstance>();
    private int charges = 0;
    private int potionCount = 0;

    public TeapotBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)RedevModBlockEntities.TEAPOT.get(), pos, state);
    }

    public boolean canAddPotion(ItemStack potion) {
        if (!potion.m_150930_(Items.f_42589_) || potion.m_150930_(Items.f_42736_) || potion.m_150930_(Items.f_42739_)) {
            return false;
        }
        return this.potionCount < 3 && !PotionUtils.m_43547_((ItemStack)potion).isEmpty();
    }

    public void addPotion(ItemStack potion) {
        if (this.canAddPotion(potion)) {
            for (MobEffectInstance effect : PotionUtils.m_43547_((ItemStack)potion)) {
                this.storedEffects.add(new MobEffectInstance(effect));
            }
            ++this.potionCount;
            ++this.charges;
            this.m_6596_();
        }
    }

    public boolean canExtractPotion() {
        return this.charges > 0 && !this.storedEffects.isEmpty();
    }

    public ItemStack extractPotion() {
        if (!this.canExtractPotion()) {
            return ItemStack.f_41583_;
        }
        ItemStack result = new ItemStack((ItemLike)Items.f_42589_);
        PotionUtils.m_43549_((ItemStack)result, (Potion)Potions.f_43598_);
        PotionUtils.m_43552_((ItemStack)result, this.storedEffects);
        result.m_41714_((Component)Component.m_237113_((String)"Mixed Potion").m_130938_(style -> style.m_131155_(Boolean.valueOf(false))));
        int color = PotionUtils.m_43564_(this.storedEffects);
        result.m_41784_().m_128405_("CustomPotionColor", color);
        --this.charges;
        if (this.charges <= 0) {
            this.storedEffects.clear();
            this.potionCount = 0;
        }
        this.m_6596_();
        return result;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.charges = tag.m_128451_("charges");
        this.potionCount = tag.m_128451_("potionCount");
        this.storedEffects.clear();
        ListTag list = tag.m_128437_("effects", 10);
        for (Tag t : list) {
            this.storedEffects.add(MobEffectInstance.m_19560_((CompoundTag)((CompoundTag)t)));
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("charges", this.charges);
        tag.m_128405_("potionCount", this.potionCount);
        ListTag list = new ListTag();
        for (MobEffectInstance effect : this.storedEffects) {
            list.add((Object)effect.m_19555_(new CompoundTag()));
        }
        tag.m_128365_("effects", (Tag)list);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

