/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Collection;
import net.mcreator.redev.entity.ConjuredSlimeEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.SlimeModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;

public class ConjuredSlimeRenderer
extends MobRenderer<ConjuredSlimeEntity, SlimeModel<ConjuredSlimeEntity>> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("redev:textures/entities/conjured_slime.png");
    private static final ResourceLocation TINTED_TEXTURE = new ResourceLocation("redev:textures/entities/conjured_slime_tint.png");

    public ConjuredSlimeRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new SlimeModel(context.m_174023_(ModelLayers.f_171241_)), 0.25f);
        this.m_115326_(new TintedSlimeOuterLayer(this, context.m_174027_()));
    }

    public ResourceLocation getTextureLocation(ConjuredSlimeEntity entity) {
        return TEXTURE;
    }

    public void render(ConjuredSlimeEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        this.f_114477_ = 0.25f * (float)entity.m_33632_();
        if (!entity.m_21220_().isEmpty()) {
            int color = ConjuredSlimeRenderer.getCombinedPotionColor(entity.m_21220_());
            float a = (float)(color >> 24 & 0xFF) / 255.0f;
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            poseStack.m_85836_();
            this.scale(entity, poseStack, partialTicks);
            ((SlimeModel)this.m_7200_()).m_7695_(poseStack, buffer.m_6299_(RenderType.m_110473_((ResourceLocation)TINTED_TEXTURE)), packedLight, ConjuredSlimeRenderer.m_115338_((LivingEntity)entity, (float)0.0f), r, g, b, a);
            poseStack.m_85849_();
        } else {
            super.m_7392_((Mob)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        }
    }

    protected void scale(ConjuredSlimeEntity entity, PoseStack poseStack, float partialTicks) {
        poseStack.m_85841_(0.999f, 0.999f, 0.999f);
        poseStack.m_252880_(0.0f, 0.001f, 0.0f);
        float size = entity.m_33632_();
        float squishFactor = Mth.m_14179_((float)partialTicks, (float)entity.f_33585_, (float)entity.f_33584_) / (size * 0.5f + 1.0f);
        float scale = 1.0f / (squishFactor + 1.0f);
        poseStack.m_85841_(scale * size, 1.0f / scale * size, scale * size);
    }

    public static int getCombinedPotionColor(Collection<MobEffectInstance> effects) {
        if (effects.isEmpty()) {
            return -1;
        }
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        int count = 0;
        for (MobEffectInstance instance : effects) {
            if (!instance.m_19572_()) continue;
            int color = instance.m_19544_().m_19484_();
            float cr = (float)(color >> 16 & 0xFF) / 255.0f;
            float cg = (float)(color >> 8 & 0xFF) / 255.0f;
            float cb = (float)(color & 0xFF) / 255.0f;
            r += cr;
            g += cg;
            b += cb;
            ++count;
        }
        if (count == 0) {
            return -1;
        }
        int ir = (int)((r /= (float)count) * 255.0f);
        int ig = (int)((g /= (float)count) * 255.0f);
        int ib = (int)((b /= (float)count) * 255.0f);
        return 0xFF000000 | ir << 16 | ig << 8 | ib;
    }

    public class TintedSlimeOuterLayer<T extends LivingEntity>
    extends RenderLayer<T, SlimeModel<T>> {
        private static final ResourceLocation TINTED_TEXTURE = new ResourceLocation("redev:textures/entities/conjured_slime_tint.png");
        private final EntityModel<T> model;

        public TintedSlimeOuterLayer(RenderLayerParent<T, SlimeModel<T>> parent, EntityModelSet modelSet) {
            super(parent);
            this.model = new SlimeModel(modelSet.m_171103_(ModelLayers.f_171242_));
        }

        public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float partialTicks) {
            boolean shouldRender;
            Minecraft mc = Minecraft.m_91087_();
            boolean glowing = mc.m_91314_(entity) && entity.m_20145_();
            boolean bl = shouldRender = !entity.m_20145_() || glowing;
            if (!shouldRender) {
                return;
            }
            VertexConsumer vertexConsumer = glowing ? buffer.m_6299_(RenderType.m_110491_((ResourceLocation)TINTED_TEXTURE)) : buffer.m_6299_(RenderType.m_110473_((ResourceLocation)TINTED_TEXTURE));
            ((SlimeModel)this.m_117386_()).m_102624_(this.model);
            this.model.m_6839_(entity, limbSwing, limbSwingAmount, partialTicks);
            this.model.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            int color = entity.m_21220_().isEmpty() ? -1 : ConjuredSlimeRenderer.getCombinedPotionColor(entity.m_21220_());
            float a = (float)(color >> 24 & 0xFF) / 255.0f;
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            this.model.m_7695_(poseStack, vertexConsumer, packedLight, LivingEntityRenderer.m_115338_(entity, (float)0.0f), r, g, b, a);
        }
    }
}

