/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.enchantment;

import java.util.UUID;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EncrustEnchantment
extends Enchantment {
    private static final UUID ARMOR_BOOST_MODIFIER = UUID.fromString("a9b2d1c3-4e5f-678a-b9cd-ef0123456789");

    public EncrustEnchantment() {
        super(Enchantment.Rarity.UNCOMMON, EnchantmentCategory.ARMOR_CHEST, new EquipmentSlot[]{EquipmentSlot.CHEST});
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public int m_6586_() {
        return 3;
    }

    public boolean canApplyAtEnchantingTable(ItemStack itemstack) {
        return itemstack.m_41720_() instanceof ElytraItem;
    }

    @SubscribeEvent
    public void onEquipmentChange(LivingEquipmentChangeEvent event) {
        int level;
        if (event.getSlot() != EquipmentSlot.CHEST) {
            return;
        }
        LivingEntity entity = event.getEntity();
        ItemStack newArmor = event.getTo();
        if (newArmor.m_41720_() instanceof ElytraItem && (level = newArmor.getEnchantmentLevel((Enchantment)this)) > 0) {
            this.applyArmorBoost(entity, level);
            return;
        }
        this.removeArmorBoost(entity);
    }

    private void applyArmorBoost(LivingEntity entity, int level) {
        AttributeInstance attributeInstance = entity.m_21051_(Attributes.f_22284_);
        if (attributeInstance == null) {
            return;
        }
        attributeInstance.m_22120_(ARMOR_BOOST_MODIFIER);
        attributeInstance.m_22118_(new AttributeModifier(ARMOR_BOOST_MODIFIER, "Encrust Armor Boost", 2.0 * (double)level, AttributeModifier.Operation.ADDITION));
    }

    private void removeArmorBoost(LivingEntity entity) {
        AttributeInstance attributeInstance = entity.m_21051_(Attributes.f_22284_);
        if (attributeInstance != null) {
            attributeInstance.m_22120_(ARMOR_BOOST_MODIFIER);
        }
    }
}

