/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.enchantment;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class OverchargeEnchantment
extends Enchantment {
    public OverchargeEnchantment(EquipmentSlot ... slots) {
        super(Enchantment.Rarity.UNCOMMON, EnchantmentCategory.BOW, slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public int m_6586_() {
        return 4;
    }

    public boolean m_6591_() {
        return true;
    }

    @SubscribeEvent
    public void onProjectileImpact(ProjectileImpactEvent event) {
        int maxChargeTime;
        Entity entity = event.getEntity();
        if (!(entity instanceof AbstractArrow)) {
            return;
        }
        AbstractArrow arrow = (AbstractArrow)entity;
        Entity entity2 = arrow.m_19749_();
        if (!(entity2 instanceof Player)) {
            return;
        }
        Player player = (Player)entity2;
        ItemStack bow = player.m_21211_();
        if (bow.m_41619_() || !bow.m_150930_(Items.f_42411_)) {
            return;
        }
        int level = EnchantmentHelper.m_44843_((Enchantment)this, (ItemStack)bow);
        if (level <= 0) {
            return;
        }
        int chargeTime = player.m_21252_();
        if (chargeTime <= (maxChargeTime = 20)) {
            return;
        }
        float overchargeFactor = (float)(chargeTime - maxChargeTime) / (float)maxChargeTime;
        overchargeFactor = Math.min(overchargeFactor, 1.0f);
        float bonusDamage = (float)((double)overchargeFactor * (0.25 * (double)level * arrow.m_36789_()));
        arrow.m_36781_(arrow.m_36789_() + (double)bonusDamage);
    }
}

