/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.enchantment;

import java.util.List;
import java.util.UUID;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class VaultingEnchantment
extends Enchantment {
    private static final UUID STEP_HEIGHT_MODIFIER = UUID.fromString("12a5c2bc-1ed3-4f7e-9c4a-aaa1b1f1c2f5");

    public VaultingEnchantment(EquipmentSlot ... slots) {
        super(Enchantment.Rarity.UNCOMMON, EnchantmentCategory.ARMOR_FEET, slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public int m_6586_() {
        return 3;
    }

    protected boolean m_5975_(Enchantment ench) {
        return this != ench && !List.of(Enchantments.f_44967_, Enchantments.f_44973_, Enchantments.f_44972_).contains(ench);
    }

    public boolean m_6591_() {
        return true;
    }

    @SubscribeEvent
    public void onLivingTick(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        int level = player.m_6844_(EquipmentSlot.FEET).getEnchantmentLevel((Enchantment)this);
        if (level > 0) {
            double stepHeightBoost = 0.5 * (double)level;
            this.applyStepHeightBoost(player, stepHeightBoost);
        } else {
            this.removeStepHeightBoost(player);
        }
    }

    private void applyStepHeightBoost(Player player, double amount) {
        AttributeInstance attributeInstance = player.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get());
        if (attributeInstance == null) {
            return;
        }
        attributeInstance.m_22120_(STEP_HEIGHT_MODIFIER);
        attributeInstance.m_22118_(new AttributeModifier(STEP_HEIGHT_MODIFIER, "Vaulting boost", amount, AttributeModifier.Operation.ADDITION));
    }

    private void removeStepHeightBoost(Player player) {
        AttributeInstance attributeInstance = player.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get());
        if (attributeInstance != null) {
            attributeInstance.m_22120_(STEP_HEIGHT_MODIFIER);
        }
    }

    @SubscribeEvent
    public void onEquipmentChange(LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (event.getSlot() == EquipmentSlot.FEET && (event.getTo() == null || event.getTo().m_41619_() || event.getTo().getEnchantmentLevel((Enchantment)this) == 0)) {
                this.removeStepHeightBoost(player);
            }
        }
    }
}

