/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.entity;

import java.util.List;
import javax.annotation.Nullable;
import net.mcreator.redev.entity.FallingIceEntity;
import net.mcreator.redev.init.RedevModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class IceologerEntity
extends SpellcasterIllager {
    private static final EntityDataAccessor<Integer> SPELL_COOLDOWN = SynchedEntityData.m_135353_(IceologerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final int CAST_DURATION = 15;

    public IceologerEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<IceologerEntity>)((EntityType)RedevModEntities.ICEOLOGER.get()), world);
    }

    public IceologerEntity(EntityType<IceologerEntity> type, Level world) {
        super(type, world);
        this.m_274367_(0.6f);
        this.f_21364_ = 8;
        this.m_21557_(false);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new IceologerSpellGoal());
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 0.6, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SPELL_COOLDOWN, (Object)this.getRandomCooldown());
    }

    public void m_6075_() {
        super.m_6075_();
        int cooldown = (Integer)this.f_19804_.m_135370_(SPELL_COOLDOWN);
        if (cooldown > 0) {
            this.f_19804_.m_135381_(SPELL_COOLDOWN, (Object)(cooldown - 1));
        }
    }

    public boolean isSpellReady() {
        return (Integer)this.f_19804_.m_135370_(SPELL_COOLDOWN) <= 0;
    }

    private void resetSpellCooldown() {
        this.f_19804_.m_135381_(SPELL_COOLDOWN, (Object)this.getRandomCooldown());
    }

    private int getRandomCooldown() {
        return this.f_19796_.m_188503_(21) + 60;
    }

    public MobType m_6336_() {
        return MobType.f_21643_;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("redev:chillager.idle"));
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("redev:chillager.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("redev:chillager.death"));
    }

    public SoundEvent m_7930_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.evoker.celebrate"));
    }

    public SoundEvent m_7894_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.evoker.cast_spell"));
    }

    public void m_7895_(int wave, boolean p_37844_) {
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata, @Nullable CompoundTag tag) {
        SpawnGroupData retval = super.m_6518_(world, difficulty, reason, livingdata, tag);
        return retval;
    }

    public static void init() {
        Raid.RaiderType.create((String)"iceologer", (EntityType)((EntityType)RedevModEntities.ICEOLOGER.get()), (int[])new int[]{0, 0, 0, 0, 0, 0, 0, 0});
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.5);
        builder = builder.m_22268_(Attributes.f_22276_, 25.0);
        builder = builder.m_22268_(Attributes.f_22281_, 3.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        return builder;
    }

    private class IceologerSpellGoal
    extends Goal {
        private int castingTicks;
        private boolean isCasting;
        private boolean isFreezeSpell;

        private IceologerSpellGoal() {
        }

        public boolean m_8036_() {
            return IceologerEntity.this.isSpellReady() && IceologerEntity.this.m_5448_() != null;
        }

        public void m_8056_() {
            this.castingTicks = 15;
            this.isCasting = true;
            boolean bl = this.isFreezeSpell = (double)IceologerEntity.this.f_19796_.m_188501_() < 0.25;
            if (this.isFreezeSpell) {
                IceologerEntity.this.m_33727_(SpellcasterIllager.IllagerSpell.FANGS);
                IceologerEntity.this.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.player.hurt_freeze")), 1.0f, 1.0f);
            } else {
                IceologerEntity.this.m_33727_(SpellcasterIllager.IllagerSpell.SUMMON_VEX);
                IceologerEntity.this.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("redev:iceologer.summon_ice")), 1.0f, 1.0f);
            }
        }

        public void m_8037_() {
            if (this.castingTicks > 0) {
                IceologerEntity.this.m_21573_().m_26573_();
            }
            --this.castingTicks;
            if (this.castingTicks == 0) {
                if (this.isFreezeSpell) {
                    this.castFreezeSpell();
                } else {
                    this.summonFallingIce();
                }
                this.m_8041_();
            }
        }

        public boolean m_8045_() {
            return this.castingTicks > 0;
        }

        public void m_8041_() {
            this.isCasting = false;
            IceologerEntity.this.m_33727_(SpellcasterIllager.IllagerSpell.NONE);
            IceologerEntity.this.resetSpellCooldown();
            IceologerEntity.this.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.evoker.cast_spell")), 1.0f, 1.0f);
        }

        private void summonFallingIce() {
            if (IceologerEntity.this.m_5448_() == null) {
                return;
            }
            LivingEntity target = IceologerEntity.this.m_5448_();
            Level world = IceologerEntity.this.m_9236_();
            BlockPos targetPos = target.m_20183_().m_6630_(3);
            FallingIceEntity fallingIce = new FallingIceEntity((EntityType<FallingIceEntity>)((EntityType)RedevModEntities.FALLING_ICE.get()), world);
            fallingIce.m_6027_(targetPos.m_123341_(), targetPos.m_123342_(), targetPos.m_123343_());
            fallingIce.m_6710_(target);
            world.m_7967_((Entity)fallingIce);
        }

        private void castFreezeSpell() {
            if (IceologerEntity.this.m_5448_() == null) {
                return;
            }
            LivingEntity target = IceologerEntity.this.m_5448_();
            Level world = IceologerEntity.this.m_9236_();
            double startX = IceologerEntity.this.m_20185_();
            double startY = IceologerEntity.this.m_20188_();
            double startZ = IceologerEntity.this.m_20189_();
            double endX = target.m_20185_();
            double endY = target.m_20188_();
            double endZ = target.m_20189_();
            double deltaX = endX - startX;
            double deltaY = endY - startY;
            double deltaZ = endZ - startZ;
            double distance = Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
            deltaX /= distance;
            deltaY /= distance;
            deltaZ /= distance;
            for (int i = 0; i < 20; ++i) {
                double factor = (double)i / 20.0;
                double posX = startX + deltaX * factor * distance;
                double posY = startY + deltaY * factor * distance;
                double posZ = startZ + deltaZ * factor * distance;
                world.m_7106_((ParticleOptions)ParticleTypes.f_175821_, posX, posY, posZ, 0.0, 0.0, 0.0);
            }
            List affectedEntities = world.m_6443_(LivingEntity.class, IceologerEntity.this.m_20191_().m_82400_(3.0), entity -> entity.m_6084_() && entity != IceologerEntity.this);
            for (LivingEntity entity2 : affectedEntities) {
                entity2.m_146917_(entity2.m_146888_() + 60);
                entity2.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 80, 1));
            }
        }
    }
}

