/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.entity;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.mcreator.redev.entity.RedstoneMineEntity;
import net.mcreator.redev.init.RedevModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class RedstoneGolemEntity
extends TamableAnimal {
    private int hurtGlowTicks = 0;
    private int attackAnimationTick;
    private int mineSummonCooldown = 0;
    private boolean isFrozenForSummon = false;
    private static final EntityDataAccessor<Boolean> PREPARING_MINE_SUMMON = SynchedEntityData.m_135353_(RedstoneGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public RedstoneGolemEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<RedstoneGolemEntity>)((EntityType)RedevModEntities.REDSTONE_GOLEM.get()), world);
    }

    public RedstoneGolemEntity(EntityType<RedstoneGolemEntity> type, Level world) {
        super(type, world);
        this.m_274367_(0.6f);
        this.f_21364_ = 0;
        this.m_21557_(false);
        this.m_21530_();
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.25);
        builder = builder.m_22268_(Attributes.f_22276_, 250.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 25.0);
        builder = builder.m_22268_(Attributes.f_22277_, 64.0);
        builder = builder.m_22268_(Attributes.f_22278_, 1.0);
        builder = builder.m_22268_(Attributes.f_22282_, 2.0);
        return builder;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new DirectAttackGoal((PathfinderMob)this, 1.0, false){

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return 1.4 * (double)(RedstoneGolemEntity.this.m_20205_() * RedstoneGolemEntity.this.m_20205_() + entity.m_20205_());
            }
        });
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new SummonMineGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(6, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(7, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PREPARING_MINE_SUMMON, (Object)false);
    }

    public boolean isPreparingMineSummon() {
        return (Boolean)this.f_19804_.m_135370_(PREPARING_MINE_SUMMON);
    }

    public void setPreparingMineSummon(boolean value) {
        this.f_19804_.m_135381_(PREPARING_MINE_SUMMON, (Object)value);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.mineSummonCooldown > 0) {
            --this.mineSummonCooldown;
        }
        if (this.hurtGlowTicks > 0) {
            --this.hurtGlowTicks;
        }
        if (this.attackAnimationTick > 0) {
            --this.attackAnimationTick;
        }
        if (this.m_20160_() && this.m_6688_() instanceof Player) {
            if (this.isFrozenForSummon) {
                return;
            }
            double radius = 3.0;
            for (LivingEntity target : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_(radius))) {
                TamableAnimal tamable;
                if (target == this || target == this.m_6688_() || target instanceof TamableAnimal && (tamable = (TamableAnimal)target).m_21824_() || !this.m_6779_(target)) continue;
                double dx = target.m_20185_() - this.m_20185_();
                double dz = target.m_20189_() - this.m_20189_();
                double angleToTarget = Math.atan2(dz, dx) * 57.29577951308232;
                double angleDiff = Math.abs(Mth.m_14177_((float)((float)angleToTarget - this.m_146908_())));
                if (!(angleDiff < 60.0)) continue;
                this.m_7327_((Entity)target);
                break;
            }
        }
    }

    public int getHurtGlowTicks() {
        return this.hurtGlowTicks;
    }

    public boolean m_7327_(Entity target) {
        this.attackAnimationTick = 10;
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        this.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("redev:redstone_golem.attack")), 1.0f, 1.0f);
        float attackDamage = (float)this.m_21133_(Attributes.f_22281_);
        boolean flag = target.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), attackDamage);
        if (flag) {
            this.m_19970_((LivingEntity)this, target);
            this.applyKnockback((LivingEntity)this, target);
        }
        double radius = 4.0;
        for (LivingEntity nearby : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_(radius))) {
            double lookAngle;
            if (nearby == this || nearby == target || !this.m_6779_(nearby)) continue;
            double dx = nearby.m_20185_() - this.m_20185_();
            double dz = nearby.m_20189_() - this.m_20189_();
            double angleTo = Math.atan2(dz, dx);
            double angleDiff = Math.abs(Mth.m_14177_((float)((float)Math.toDegrees(angleTo - (lookAngle = (double)this.m_146908_() * (Math.PI / 180))))));
            if (!(angleDiff <= 90.0)) continue;
            nearby.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), attackDamage * 0.6f);
            this.applyKnockback((LivingEntity)this, (Entity)nearby);
        }
        return flag;
    }

    private void applyKnockback(LivingEntity source, Entity target) {
        double knockbackStrength = source.m_21133_(Attributes.f_22282_);
        if (knockbackStrength > 0.0) {
            double dx = target.m_20185_() - source.m_20185_();
            double dz = target.m_20189_() - source.m_20189_();
            double distance = Math.max(Math.sqrt(dx * dx + dz * dz), 0.01);
            double knockbackX = dx / distance * knockbackStrength * 1.3;
            double knockbackZ = dz / distance * knockbackStrength * 1.3;
            double knockbackY = 0.4 * knockbackStrength;
            target.m_20256_(target.m_20184_().m_82520_(knockbackX, knockbackY, knockbackZ));
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.isRepairItem(stack) && this.m_21223_() < this.m_21233_()) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            this.m_5634_(4.0f);
            this.m_9236_().m_7605_((Entity)this, (byte)7);
            this.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("minecraft:block.redstone_torch.burnout")), 1.0f, 1.0f);
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        if (player == this.m_269323_() && !player.m_6144_()) {
            player.m_20329_((Entity)this);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_6094_() {
        return !this.m_20160_();
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity entity = this.m_146895_();
        return entity instanceof Player ? (Player)entity : null;
    }

    protected void m_274498_(Player rider, Vec3 travelVector) {
        this.m_19915_(rider.m_146908_(), rider.m_146909_() * 0.5f);
        this.f_20883_ = this.f_20885_ = this.m_146908_();
        this.f_19859_ = this.f_20885_;
        super.m_274498_(rider, travelVector);
    }

    protected Vec3 m_274312_(Player rider, Vec3 travelVector) {
        return new Vec3(0.0, 0.0, this.m_21133_(Attributes.f_22279_));
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_6109_() && !this.isFrozenForSummon) {
            this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
            super.m_7023_(travelVector);
        } else {
            super.m_7023_(travelVector);
        }
    }

    protected void m_19956_(Entity passenger, Entity.MoveFunction moveFunction) {
        if (passenger.m_20202_() == this) {
            float forwardOffset = 0.5f;
            double verticalOffset = this.m_6048_() - 0.5 + passenger.m_6049_() + 1.0;
            Vec3 offset = new Vec3(0.0, 0.0, (double)forwardOffset).m_82524_(-this.f_20883_ * ((float)Math.PI / 180));
            moveFunction.m_20372_(passenger, this.m_20185_() + offset.f_82479_, this.m_20186_() + verticalOffset, this.m_20189_() + offset.f_82481_);
            passenger.m_146922_(this.m_146908_());
            passenger.m_5616_(this.m_146908_());
            passenger.m_5618_(this.m_146908_());
        }
    }

    public AgeableMob m_142606_(ServerLevel world, AgeableMob parent) {
        RedstoneGolemEntity child = (RedstoneGolemEntity)((EntityType)RedevModEntities.REDSTONE_GOLEM.get()).m_20615_((Level)world);
        child.m_6518_((ServerLevelAccessor)world, world.m_6436_(child.m_20183_()), MobSpawnType.BREEDING, null, null);
        return child;
    }

    public boolean m_6898_(ItemStack stack) {
        return this.isRepairItem(stack);
    }

    public boolean isRepairItem(ItemStack stack) {
        return stack.m_150930_(Items.f_42542_);
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("redev:redstone_golem.idle"));
    }

    public SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("redev:redstone_golem.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("redev:redstone_golem.death"));
    }

    public void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("redev:redstone_golem.step")), 0.15f, 1.0f);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_276093_(DamageTypes.f_268631_) || source.m_276093_(DamageTypes.f_268671_) || source.m_276093_(DamageTypes.f_268585_) || source.m_276093_(DamageTypes.f_268722_) || source.m_276093_(DamageTypes.f_268450_) || source.m_276093_(DamageTypes.f_268565_) || source.m_276093_(DamageTypes.f_268448_)) {
            return false;
        }
        if (super.m_6469_(source, amount)) {
            if (!this.m_9236_().f_46443_) {
                this.m_9236_().m_7605_((Entity)this, (byte)9);
            }
            return true;
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_6128_() {
        return true;
    }

    public boolean m_5825_() {
        return true;
    }

    public boolean m_6785_(double dist) {
        return false;
    }

    public int getAttackAnimationTick() {
        return this.attackAnimationTick;
    }

    public void m_7822_(byte id) {
        if (id == 4) {
            this.attackAnimationTick = 10;
        } else if (id == 9) {
            this.hurtGlowTicks = 30;
        } else {
            super.m_7822_(id);
        }
    }

    public class SummonMineGoal
    extends Goal {
        private final RedstoneGolemEntity golem;
        private int summonTick = -1;

        public SummonMineGoal(RedstoneGolemEntity golem) {
            this.golem = golem;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.golem.mineSummonCooldown <= 0 && this.golem.m_5448_() != null && this.golem.m_5448_().m_6084_() && !this.golem.m_20160_();
        }

        public void m_8056_() {
            this.summonTick = 0;
            this.golem.setPreparingMineSummon(true);
            this.golem.m_21573_().m_26573_();
            this.golem.isFrozenForSummon = true;
        }

        public void m_8041_() {
            this.summonTick = -1;
            this.golem.mineSummonCooldown = 20 * (6 + this.golem.m_217043_().m_188503_(5));
            this.golem.setPreparingMineSummon(false);
            this.golem.isFrozenForSummon = false;
        }

        public void m_8037_() {
            if (this.golem.m_5448_() != null) {
                this.golem.m_21563_().m_24960_((Entity)this.golem.m_5448_(), 30.0f, 30.0f);
            }
            if (this.summonTick >= 40) {
                this.golem.isFrozenForSummon = false;
            }
            ++this.summonTick;
            if (this.summonTick == 20 && !this.golem.m_9236_().f_46443_) {
                ServerLevel serverLevel = (ServerLevel)this.golem.m_9236_();
                int count = 8 + this.golem.m_217043_().m_188503_(8);
                for (int i = 0; i < count; ++i) {
                    double angle = Math.PI * 2 * (double)i / (double)count;
                    double radius = 3.0 + this.golem.m_217043_().m_188500_() * 2.0;
                    double x = this.golem.m_20185_() + Math.cos(angle) * radius;
                    double z = this.golem.m_20189_() + Math.sin(angle) * radius;
                    double y = this.golem.m_20186_();
                    RedstoneMineEntity mine = (RedstoneMineEntity)((EntityType)RedevModEntities.REDSTONE_MINE.get()).m_20615_((Level)serverLevel);
                    if (mine == null) continue;
                    mine.m_7678_(x, y, z, this.golem.m_146908_(), 0.0f);
                    mine.setIsReal(this.golem.m_217043_().m_188501_() < 0.8f);
                    mine.setLifeTicks(10 + this.golem.m_217043_().m_188503_(31));
                    serverLevel.m_7967_((Entity)mine);
                }
            }
        }

        public boolean m_8045_() {
            return this.summonTick >= 0 && this.summonTick < 40;
        }

        public boolean m_183429_() {
            return true;
        }
    }

    public class DirectAttackGoal
    extends Goal {
        protected final PathfinderMob mob;
        private final double speedModifier;
        private final boolean followingTargetEvenIfNotSeen;
        private Path path;
        private double pathedTargetX;
        private double pathedTargetY;
        private double pathedTargetZ;
        private int ticksUntilNextPathRecalculation;
        private int ticksUntilNextAttack;
        private final int attackInterval = 20;
        private long lastCanUseCheck;
        private static final long COOLDOWN_BETWEEN_CAN_USE_CHECKS = 20L;
        private int failedPathFindingPenalty = 0;
        private boolean canPenalize = false;

        public DirectAttackGoal(PathfinderMob mob, double speed, boolean followTarget) {
            this.mob = mob;
            this.speedModifier = speed;
            this.followingTargetEvenIfNotSeen = followTarget;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            long gameTime = this.mob.m_9236_().m_46467_();
            if (gameTime - this.lastCanUseCheck < 20L) {
                return false;
            }
            this.lastCanUseCheck = gameTime;
            LivingEntity target = this.mob.m_5448_();
            if (target == null || !target.m_6084_()) {
                return false;
            }
            if (this.canPenalize) {
                if (--this.ticksUntilNextPathRecalculation <= 0) {
                    this.path = this.mob.m_21573_().m_6570_((Entity)target, 0);
                    this.ticksUntilNextPathRecalculation = 4 + this.mob.m_217043_().m_188503_(7);
                    return this.path != null;
                }
                return true;
            }
            this.path = this.mob.m_21573_().m_6570_((Entity)target, 0);
            if (this.path != null) {
                return true;
            }
            return this.getAttackReachSqr(target) >= this.mob.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
        }

        public boolean m_8045_() {
            LivingEntity target = this.mob.m_5448_();
            if (target == null || !target.m_6084_()) {
                return false;
            }
            if (!this.followingTargetEvenIfNotSeen) {
                return !this.mob.m_21573_().m_26571_();
            }
            if (!this.mob.m_21444_(target.m_20183_())) {
                return false;
            }
            return !(target instanceof Player) || !target.m_5833_() && !((Player)target).m_7500_();
        }

        public void m_8056_() {
            LivingEntity target = this.mob.m_5448_();
            if (this.path != null && this.path.m_77395_() != null) {
                Node end = this.path.m_77395_();
                this.mob.m_21573_().m_26519_((double)end.f_77271_ + 0.5, (double)end.f_77272_, (double)end.f_77273_ + 0.5, this.speedModifier);
            } else if (target != null) {
                this.mob.m_21573_().m_5624_((Entity)target, this.speedModifier);
            }
            this.mob.m_21561_(true);
            this.ticksUntilNextPathRecalculation = 0;
            this.ticksUntilNextAttack = 0;
        }

        public void m_8041_() {
            Player player;
            LivingEntity target = this.mob.m_5448_();
            if (target instanceof Player && ((player = (Player)target).m_7500_() || player.m_5833_())) {
                this.mob.m_6710_(null);
            }
            this.mob.m_21561_(false);
            this.mob.m_21573_().m_26573_();
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity target = this.mob.m_5448_();
            if (target != null) {
                this.mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                double dx = target.m_20185_() - this.mob.m_20185_();
                double dz = target.m_20189_() - this.mob.m_20189_();
                float yaw = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                this.mob.m_146922_(yaw);
                this.mob.f_20883_ = yaw;
                this.mob.f_20885_ = yaw;
                double distSq = this.mob.m_262793_(target);
                this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
                if ((this.followingTargetEvenIfNotSeen || this.mob.m_21574_().m_148306_((Entity)target)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || target.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.m_217043_().m_188501_() < 0.05f)) {
                    this.pathedTargetX = target.m_20185_();
                    this.pathedTargetY = target.m_20186_();
                    this.pathedTargetZ = target.m_20189_();
                    this.ticksUntilNextPathRecalculation = 4 + this.mob.m_217043_().m_188503_(7);
                    if (this.canPenalize) {
                        Node finalPathPoint;
                        this.ticksUntilNextPathRecalculation += this.failedPathFindingPenalty;
                        this.failedPathFindingPenalty = this.mob.m_21573_().m_26570_() != null ? ((finalPathPoint = this.mob.m_21573_().m_26570_().m_77395_()) != null && target.m_20275_((double)finalPathPoint.f_77271_, (double)finalPathPoint.f_77272_, (double)finalPathPoint.f_77273_) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
                    }
                    if (distSq > 1024.0) {
                        this.ticksUntilNextPathRecalculation += 10;
                    } else if (distSq > 256.0) {
                        this.ticksUntilNextPathRecalculation += 5;
                    }
                    Path newPath = this.mob.m_21573_().m_6570_((Entity)target, 0);
                    if (newPath != null && newPath.m_77395_() != null) {
                        Node end = newPath.m_77395_();
                        this.mob.m_21573_().m_26519_((double)end.f_77271_ + 0.5, (double)end.f_77272_, (double)end.f_77273_ + 0.5, this.speedModifier);
                    } else {
                        this.mob.m_21573_().m_5624_((Entity)target, this.speedModifier);
                    }
                    this.ticksUntilNextPathRecalculation = this.m_183277_(this.ticksUntilNextPathRecalculation);
                }
                this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
                this.checkAndPerformAttack(target, distSq);
            }
        }

        protected void checkAndPerformAttack(LivingEntity target, double distanceSq) {
            double reach = this.getAttackReachSqr(target);
            if (distanceSq <= reach && this.ticksUntilNextAttack <= 0) {
                this.resetAttackCooldown();
                this.mob.m_6674_(InteractionHand.MAIN_HAND);
                this.mob.m_7327_((Entity)target);
            }
        }

        protected void resetAttackCooldown() {
            this.ticksUntilNextAttack = this.m_183277_(this.attackInterval);
        }

        protected boolean isTimeToAttack() {
            return this.ticksUntilNextAttack <= 0;
        }

        protected int getTicksUntilNextAttack() {
            return this.ticksUntilNextAttack;
        }

        protected int getAttackInterval() {
            return this.m_183277_(this.attackInterval);
        }

        protected double getAttackReachSqr(LivingEntity target) {
            return this.mob.m_20205_() * 2.0f * this.mob.m_20205_() * 2.0f + target.m_20205_();
        }
    }
}

