/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.entity;

import javax.annotation.Nullable;
import net.mcreator.redev.entity.GeomancerEntity;
import net.mcreator.redev.init.RedevModEntities;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class WindcallerEntity
extends SpellcasterIllager {
    private static final EntityDataAccessor<Integer> SPELL_COOLDOWN = SynchedEntityData.m_135353_(GeomancerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final int CAST_DURATION = 20;

    public WindcallerEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<WindcallerEntity>)((EntityType)RedevModEntities.WINDCALLER.get()), world);
    }

    public WindcallerEntity(EntityType<WindcallerEntity> type, Level world) {
        super(type, world);
        this.m_274367_(0.6f);
        this.f_21364_ = 6;
        this.m_21557_(false);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new WindcallerSpellGoal());
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 0.8, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SPELL_COOLDOWN, (Object)this.getRandomCooldown());
    }

    public void m_6075_() {
        super.m_6075_();
        int cooldown = (Integer)this.f_19804_.m_135370_(SPELL_COOLDOWN);
        if (cooldown > 0) {
            this.f_19804_.m_135381_(SPELL_COOLDOWN, (Object)(cooldown - 1));
        }
    }

    public boolean isSpellReady() {
        return (Integer)this.f_19804_.m_135370_(SPELL_COOLDOWN) <= 0;
    }

    private void resetSpellCooldown() {
        this.f_19804_.m_135381_(SPELL_COOLDOWN, (Object)this.getRandomCooldown());
    }

    private int getRandomCooldown() {
        return this.f_19796_.m_188503_(21) + 80;
    }

    public MobType m_6336_() {
        return MobType.f_21643_;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("redev:windcaller.idle"));
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("redev:windcaller.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("redev:windcaller.death"));
    }

    public SoundEvent m_7930_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.evoker.celebrate"));
    }

    public SoundEvent m_7894_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.evoker.cast_spell"));
    }

    public void m_7895_(int wave, boolean p_37844_) {
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata, @Nullable CompoundTag tag) {
        SpawnGroupData retval = super.m_6518_(world, difficulty, reason, livingdata, tag);
        return retval;
    }

    public static void init() {
        Raid.RaiderType.create((String)"windcaller", (EntityType)((EntityType)RedevModEntities.WINDCALLER.get()), (int[])new int[]{0, 0, 0, 0, 0, 0, 0, 0});
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.4);
        builder = builder.m_22268_(Attributes.f_22276_, 20.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 3.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        return builder;
    }

    private class WindcallerSpellGoal
    extends Goal {
        private int castingTicks;
        private boolean isCasting;
        private boolean isLiftSpell;

        private WindcallerSpellGoal() {
        }

        public boolean m_8036_() {
            return WindcallerEntity.this.isSpellReady() && WindcallerEntity.this.m_5448_() != null;
        }

        public void m_8056_() {
            this.castingTicks = 20;
            this.isCasting = true;
            this.isLiftSpell = WindcallerEntity.this.m_217043_().m_188501_() < 0.6f;
            WindcallerEntity.this.m_33727_(SpellcasterIllager.IllagerSpell.WOLOLO);
            WindcallerEntity.this.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.evoker.prepare_attack")), 1.0f, 1.0f);
        }

        public void m_8037_() {
            if (this.castingTicks > 0) {
                WindcallerEntity.this.m_21573_().m_26573_();
            }
            --this.castingTicks;
            if (this.castingTicks == 0) {
                if (this.isLiftSpell) {
                    this.castLiftSpell();
                } else {
                    this.castBlastSpell();
                }
                this.m_8041_();
            }
        }

        public boolean m_8045_() {
            return this.castingTicks > 0;
        }

        public void m_8041_() {
            this.isCasting = false;
            WindcallerEntity.this.m_33727_(SpellcasterIllager.IllagerSpell.NONE);
            WindcallerEntity.this.resetSpellCooldown();
            WindcallerEntity.this.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.evoker.cast_spell")), 1.0f, 1.0f);
        }

        private void castLiftSpell() {
            if (WindcallerEntity.this.m_5448_() == null) {
                return;
            }
            Vec3 liftForce = new Vec3(0.0, 0.5 + (double)WindcallerEntity.this.m_217043_().m_188501_() * 0.3, 0.0);
            WindcallerEntity.this.m_5448_().m_20256_(liftForce);
            WindcallerEntity.this.m_5448_().f_19812_ = true;
            Vec3 targetPos = WindcallerEntity.this.m_5448_().m_20182_();
            Level world = WindcallerEntity.this.m_9236_();
            world.m_7106_((ParticleOptions)ParticleTypes.f_123777_, targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_, 0.0, 0.1, 0.0);
        }

        private void castBlastSpell() {
            if (WindcallerEntity.this.m_5448_() == null) {
                return;
            }
            Vec3 windcallerPos = WindcallerEntity.this.m_20182_();
            Vec3 targetPos = WindcallerEntity.this.m_5448_().m_20182_();
            Vec3 blastDirection = targetPos.m_82546_(windcallerPos).m_82541_();
            WindcallerEntity.this.m_5448_().m_5997_(blastDirection.f_82479_ * 0.6, 0.3, blastDirection.f_82481_ * 0.6);
            WindcallerEntity.this.m_5448_().f_19812_ = true;
            Level world = WindcallerEntity.this.m_9236_();
            for (int i = 0; i < 5; ++i) {
                Vec3 particlePos = windcallerPos.m_82549_(blastDirection.m_82490_((double)i));
                world.m_7106_((ParticleOptions)ParticleTypes.f_123777_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 0.0, 0.1, 0.0);
            }
        }
    }
}

