/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.procedures;

import java.util.ArrayList;
import java.util.Map;
import net.mcreator.redev.init.RedevModItems;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class BoundItemsEventProcedure {
    private static final Map<Item, ChatFormatting> DYE_COLORS = Map.ofEntries(Map.entry(Items.f_42535_, ChatFormatting.WHITE), Map.entry(Items.f_42491_, ChatFormatting.GRAY), Map.entry(Items.f_42490_, ChatFormatting.DARK_GRAY), Map.entry(Items.f_42498_, ChatFormatting.BLACK), Map.entry(Items.f_42497_, ChatFormatting.RED), Map.entry(Items.f_42536_, ChatFormatting.GOLD), Map.entry(Items.f_42539_, ChatFormatting.YELLOW), Map.entry(Items.f_42540_, ChatFormatting.GREEN), Map.entry(Items.f_42496_, ChatFormatting.DARK_GREEN), Map.entry(Items.f_42492_, ChatFormatting.DARK_AQUA), Map.entry(Items.f_42538_, ChatFormatting.AQUA), Map.entry(Items.f_42494_, ChatFormatting.BLUE), Map.entry(Items.f_42493_, ChatFormatting.DARK_PURPLE), Map.entry(Items.f_42537_, ChatFormatting.LIGHT_PURPLE), Map.entry(Items.f_42489_, ChatFormatting.LIGHT_PURPLE), Map.entry(Items.f_42495_, ChatFormatting.DARK_RED));

    @SubscribeEvent
    public static void onAnvilUpdate(AnvilUpdateEvent event) {
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        if (left.m_41619_() || left.m_41613_() != 1) {
            return;
        }
        ItemStack result = left.m_41777_();
        if (right.m_150930_(Items.f_220224_)) {
            result = left.m_41777_();
            event.setMaterialCost(1);
            result.m_41742_(0);
            event.setCost(5);
            event.setOutput(result);
        } else if (right.m_150930_(Items.f_42419_) && left.m_41763_() && left.m_41773_() > 0) {
            result.m_41721_(Math.max(0, left.m_41773_() - left.m_41776_() / 4));
            event.setMaterialCost(1);
            event.setCost(1);
            event.setOutput(result);
        } else if (right.m_150930_(Items.f_151049_)) {
            CompoundTag tag = result.m_41784_();
            ListTag enchantList = new ListTag();
            enchantList.add((Object)new CompoundTag());
            tag.m_128365_("Enchantments", (Tag)enchantList);
            result.m_41751_(tag);
            event.setMaterialCost(1);
            event.setCost(1);
            event.setOutput(result);
        } else if (right.m_150930_(Items.f_42714_)) {
            CompoundTag tag = result.m_41784_();
            int hideFlags = tag.m_128451_("HideFlags");
            hideFlags |= 1;
            tag.m_128405_("HideFlags", hideFlags |= 8);
            tag.m_128379_("GlintHidden", true);
            result.m_41751_(tag);
            event.setMaterialCost(1);
            event.setCost(1);
            event.setOutput(result);
        } else if (right.m_150930_(Items.f_42656_) && right.m_41788_()) {
            CompoundTag displayTag = result.m_41698_("display");
            ListTag loreList = displayTag.m_128425_("Lore", 9) ? displayTag.m_128437_("Lore", 8) : new ListTag();
            Component name = right.m_41786_();
            StringTag loreLine = StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)name));
            loreList.add((Object)loreLine);
            displayTag.m_128365_("Lore", (Tag)loreList);
            result.m_41784_().m_128365_("display", (Tag)displayTag);
            event.setMaterialCost(1);
            event.setCost(0);
            event.setOutput(result);
        } else if (right.m_150930_(Items.f_42415_) && left.m_41763_()) {
            CompoundTag tag = result.m_41784_();
            int current = tag.m_128451_("SpecialDurability");
            tag.m_128405_("SpecialDurability", current + 32);
            result.m_41751_(tag);
            event.setMaterialCost(1);
            event.setCost(2 + current / 32);
            event.setOutput(result);
        } else if (right.m_150930_(Items.f_42542_)) {
            CompoundTag tag = result.m_41784_();
            tag.m_128379_("FireResistant", true);
            result.m_41751_(tag);
            event.setOutput(result);
            event.setCost(3);
            event.setMaterialCost(1);
        } else if (DYE_COLORS.containsKey(right.m_41720_())) {
            ChatFormatting color = DYE_COLORS.get(right.m_41720_());
            String baseName = StringUtil.m_14406_((String)left.m_41786_().getString());
            result.m_41714_((Component)Component.m_237113_((String)baseName).m_130938_(style -> style.m_131140_(color).m_131155_(Boolean.valueOf(false))));
            event.setOutput(result);
            event.setCost(1);
            event.setMaterialCost(1);
        } else if (right.m_150930_((Item)RedevModItems.BINDING_CHAINS.get()) && left.m_41613_() == 1) {
            CompoundTag tag = result.m_41784_();
            tag.m_128379_("BoundToPlayer", true);
            result.m_41751_(tag);
            event.setMaterialCost(1);
            event.setCost(2);
            event.setOutput(result);
        } else if (right.m_150930_((Item)RedevModItems.GILDING_STRING.get()) && left.m_41720_() instanceof ArmorItem) {
            CompoundTag tag = result.m_41784_();
            tag.m_128379_("Gilded", true);
            CompoundTag display = tag.m_128469_("display");
            ListTag lore = display.m_128425_("Lore", 9) ? display.m_128437_("Lore", 8) : new ListTag();
            lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237113_((String)"Gilded").m_130938_(style -> style.m_131140_(ChatFormatting.GOLD).m_131155_(Boolean.valueOf(false))))));
            display.m_128365_("Lore", (Tag)lore);
            tag.m_128365_("display", (Tag)display);
            result.m_41751_(tag);
            event.setOutput(result);
            event.setCost(3);
            event.setMaterialCost(1);
        }
    }

    @SubscribeEvent
    public static void onItemBreak(PlayerDestroyItemEvent event) {
        ItemStack stack = event.getOriginal();
        if (!stack.m_41763_()) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        int specialDurability = tag.m_128451_("SpecialDurability");
        if (specialDurability > 0) {
            tag.m_128405_("SpecialDurability", specialDurability - 1);
            ItemStack repaired = stack.m_41777_();
            repaired.m_41721_(stack.m_41776_() - 1);
            repaired.m_41751_(tag);
            event.getEntity().m_150109_().m_36054_(repaired);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDropsEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).m_9236_().m_5776_()) {
            return;
        }
        ArrayList<ItemStack> toKeep = new ArrayList<ItemStack>();
        for (ItemEntity drop : event.getDrops()) {
            ItemStack stack = drop.m_32055_();
            if (!stack.m_41784_().m_128471_("BoundToPlayer")) continue;
            toKeep.add(stack.m_41777_());
            drop.m_32045_(ItemStack.f_41583_);
        }
        if (!toKeep.isEmpty()) {
            CompoundTag tag = player.getPersistentData();
            ListTag savedItems = new ListTag();
            for (ItemStack stack : toKeep) {
                savedItems.add((Object)stack.m_41739_(new CompoundTag()));
            }
            tag.m_128365_("redev_SoulboundItems", (Tag)savedItems);
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        CompoundTag oldData = event.getOriginal().getPersistentData();
        if (!oldData.m_128441_("redev_SoulboundItems")) {
            return;
        }
        ListTag saved = oldData.m_128437_("redev_SoulboundItems", 10);
        for (Tag t : saved) {
            ItemStack stack = ItemStack.m_41712_((CompoundTag)((CompoundTag)t));
            event.getEntity().m_150109_().m_36054_(stack);
        }
        oldData.m_128473_("redev_SoulboundItems");
    }

    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        CompoundTag tag;
        ItemStack stack = event.getItemStack();
        if (!stack.m_41763_()) {
            return;
        }
        int buffer = stack.m_41784_().m_128451_("SpecialDurability");
        if (buffer > 0) {
            event.getToolTip().add(Component.m_237113_((String)("\u00a7bDiamond Durability: " + buffer)));
        }
        if ((tag = stack.m_41784_()).m_128471_("BoundToPlayer")) {
            event.getToolTip().add(Component.m_237113_((String)"Soulbound").m_130938_(style -> style.m_131140_(ChatFormatting.AQUA).m_131155_(Boolean.valueOf(false))));
        }
    }
}

