/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.procedures;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.mcreator.redev.init.RedevModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class RedstoneGolemBuildProcedure {
    @SubscribeEvent
    public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        RedstoneGolemBuildProcedure.execute((Event)event, event.getLevel(), event.getPos().m_123341_(), event.getPos().m_123342_(), event.getPos().m_123343_(), event.getEntity());
    }

    public static void execute(LevelAccessor world, double x, double y, double z, @Nullable Entity placer) {
        RedstoneGolemBuildProcedure.execute(null, world, x, y, z, placer);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, double x, double y, double z, @Nullable Entity builder) {
        Direction[] directions;
        BlockPos basePos = BlockPos.m_274561_((double)x, (double)y, (double)z);
        if (world.m_8055_(basePos).m_60734_() != Blocks.f_50143_) {
            return;
        }
        int[][] baseOffsets = new int[][]{{0, 0, -1}, {0, 0, -2}, {0, 0, -3}, {-1, 0, -1}, {-1, 0, -2}, {-1, 0, -3}, {1, 0, -1}, {1, 0, -2}, {1, 0, -3}, {0, 1, -1}, {0, 1, -2}, {0, 1, -3}, {-1, 1, -1}, {-1, 1, -2}, {-1, 1, -3}, {1, 1, -1}, {1, 1, -2}, {1, 1, -3}, {0, -1, -1}, {0, -1, -2}, {0, -1, -3}, {-1, -1, -1}, {-1, -1, -2}, {-1, -1, -3}, {1, -1, -1}, {1, -1, -2}, {1, -1, -3}};
        for (Direction dir : directions = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST}) {
            List<BlockPos> matchingBlocks = RedstoneGolemBuildProcedure.getMatchingStructure(world, basePos, baseOffsets, dir);
            if (matchingBlocks == null) continue;
            if (world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                BlockPos redstonePos = RedstoneGolemBuildProcedure.rotateOffset(basePos, 0, 0, -2, dir);
                Entity entityToSpawn = ((EntityType)RedevModEntities.REDSTONE_GOLEM.get()).m_262496_(serverLevel, redstonePos, MobSpawnType.MOB_SUMMONED);
                if (entityToSpawn != null) {
                    entityToSpawn.m_20334_(0.0, 0.0, 0.0);
                    entityToSpawn.m_146922_(dir.m_122435_());
                    if (entityToSpawn instanceof TamableAnimal) {
                        TamableAnimal tamable = (TamableAnimal)entityToSpawn;
                        if (builder instanceof Player) {
                            Player player = (Player)builder;
                            tamable.m_21828_(player);
                        }
                    }
                }
                for (BlockPos pos : matchingBlocks) {
                    BlockState state = world.m_8055_(pos);
                    world.m_46961_(pos, false);
                }
                world.m_46961_(basePos, false);
            }
            return;
        }
    }

    private static List<BlockPos> getMatchingStructure(LevelAccessor world, BlockPos basePos, int[][] structure, Direction facing) {
        ArrayList<BlockPos> matched = new ArrayList<BlockPos>();
        for (int[] offset : structure) {
            BlockPos rotated = RedstoneGolemBuildProcedure.rotateOffset(basePos, offset[0], offset[1], offset[2], facing);
            if (offset[0] == 0 && offset[1] == 0 && offset[2] == -2 ? world.m_8055_(rotated).m_60734_() != Blocks.f_50330_ : world.m_8055_(rotated).m_60734_() != Blocks.f_50075_) {
                return null;
            }
            matched.add(rotated);
        }
        return matched;
    }

    private static BlockPos rotateOffset(BlockPos origin, int dx, int dy, int dz, Direction facing) {
        int rx = 0;
        int rz = 0;
        switch (facing) {
            case NORTH: {
                rx = dx;
                rz = dz;
                break;
            }
            case SOUTH: {
                rx = -dx;
                rz = -dz;
                break;
            }
            case EAST: {
                rx = -dz;
                rz = dx;
                break;
            }
            case WEST: {
                rx = dz;
                rz = -dx;
            }
        }
        return origin.m_7918_(rx, dy, rz);
    }
}

