/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.world.feature.configured;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.phys.Vec3;

public class CustomWallFeature
extends Feature<Configuration> {
    public CustomWallFeature(Codec<Configuration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<Configuration> context) {
        WorldGenLevel world = context.m_159774_();
        BlockPos origin = context.m_159777_();
        RandomSource random = context.m_225041_();
        Configuration config = (Configuration)context.m_159778_();
        ArrayList<BlockPos> pathPoints = new ArrayList<BlockPos>();
        ArrayList<Double> radiusList = new ArrayList<Double>();
        ArrayList<Double> heightList = new ArrayList<Double>();
        BlockPos current = origin;
        Vec3 direction = new Vec3(1.0, 0.0, 0.0);
        for (int i = 0; i < config.length(); ++i) {
            double dx = direction.f_82479_ + (random.m_188500_() - 0.5) * (double)config.curveStrength();
            double dz = direction.f_82481_ + (random.m_188500_() - 0.5) * (double)config.curveStrength();
            double len = Math.sqrt(dx * dx + dz * dz);
            direction = new Vec3(dx / len, 0.0, dz / len);
            int stepX = (int)Math.round(direction.f_82479_);
            int stepZ = (int)Math.round(direction.f_82481_);
            BlockPos step = current.m_7918_(stepX, 0, stepZ);
            int surfaceY = world.m_5452_(Heightmap.Types.WORLD_SURFACE_WG, step).m_123342_();
            BlockPos groundPos = new BlockPos(step.m_123341_(), surfaceY - 1, step.m_123343_());
            BlockState groundState = world.m_8055_(groundPos);
            if (!groundState.m_60815_()) continue;
            float sampledHeight = config.height().m_214084_(random);
            float sampledRadius = config.width().m_214084_(random);
            current = new BlockPos(step.m_123341_(), surfaceY + (int)(sampledHeight / 2.0f), step.m_123343_());
            pathPoints.add(current.m_7949_());
            radiusList.add(Double.valueOf(sampledRadius));
            heightList.add(Double.valueOf(sampledHeight));
        }
        this.generateWall(world, pathPoints, radiusList, heightList, config, random);
        return true;
    }

    private void generateWall(WorldGenLevel world, List<BlockPos> pathPoints, List<Double> radiusList, List<Double> heightList, Configuration config, RandomSource random) {
        for (int i = 0; i < pathPoints.size(); ++i) {
            BlockPos center = pathPoints.get(i);
            double radius = radiusList.get(i);
            double height = heightList.get(i);
            int maxWidth = (int)Math.ceil(radius * 1.5);
            int maxHeight = (int)Math.ceil(height);
            BlockPos.m_121940_((BlockPos)center.m_7918_(-maxWidth, -maxHeight, -maxWidth), (BlockPos)center.m_7918_(maxWidth, maxHeight, maxWidth)).forEach(pos -> {
                double dx = pos.m_123341_() - center.m_123341_();
                double dz = pos.m_123343_() - center.m_123343_();
                double horizontalDist = Math.sqrt(dx * dx + dz * dz);
                double verticalOffset = pos.m_123342_() - center.m_123342_();
                double verticalNorm = Math.max(0.0, Math.min(1.0, verticalOffset / height));
                double horizNorm = Math.max(0.0, Math.min(1.0, horizontalDist / radius));
                double shape = (1.0 - Math.pow(horizNorm, 2.5)) * (1.0 - Math.pow(verticalNorm, config.rigidity()));
                if (shape > 0.2) {
                    BlockState existing = world.m_8055_(pos);
                    if (config.carveTerrain() || !existing.m_60815_()) {
                        BlockState state = config.boulderBlock().m_213972_(random, pos);
                        world.m_7731_(pos, state, 3);
                    }
                }
            });
        }
    }

    public record Configuration(BlockStateProvider boulderBlock, FloatProvider width, FloatProvider height, int length, float curveStrength, boolean carveTerrain, double rigidity) implements FeatureConfiguration
    {
        public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockStateProvider.f_68747_.fieldOf("boulder_block").forGetter(Configuration::boulderBlock), (App)FloatProvider.f_146502_.fieldOf("width").forGetter(Configuration::width), (App)FloatProvider.f_146502_.fieldOf("height").forGetter(Configuration::height), (App)Codec.INT.fieldOf("length").forGetter(Configuration::length), (App)Codec.FLOAT.fieldOf("curve_strength").forGetter(Configuration::curveStrength), (App)Codec.BOOL.fieldOf("carve_terrain").forGetter(Configuration::carveTerrain), (App)Codec.DOUBLE.fieldOf("rigidity").forGetter(Configuration::rigidity)).apply((Applicative)instance, Configuration::new));
    }
}

