/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.world.feature.treedecorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import net.mcreator.redev.custom.init.RedevModTreeDecoratorTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class BranchDecorator
extends TreeDecorator {
    public static final Codec<BranchDecorator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(d -> Float.valueOf(d.probability)), (App)BlockStateProvider.f_68747_.fieldOf("log_provider").forGetter(d -> d.logProvider)).apply((Applicative)instance, BranchDecorator::new));
    private final float probability;
    private final BlockStateProvider logProvider;

    public BranchDecorator(float probability, BlockStateProvider logProvider) {
        this.probability = probability;
        this.logProvider = logProvider;
    }

    protected TreeDecoratorType<?> m_6663_() {
        return (TreeDecoratorType)RedevModTreeDecoratorTypes.BRANCH.get();
    }

    public void m_214187_(TreeDecorator.Context context) {
        RandomSource random = context.m_226067_();
        if (random.m_188501_() >= this.probability) {
            return;
        }
        ObjectArrayList logs = context.m_226068_();
        int baseY = ((BlockPos)logs.get(0)).m_123342_();
        ArrayList<BlockPos> placedBranches = new ArrayList<BlockPos>();
        for (BlockPos logPos : logs) {
            if (logPos.m_123342_() - baseY < 4) continue;
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                if (!(random.m_188501_() <= 0.035f)) continue;
                Direction opposite = dir.m_122424_();
                BlockPos targetPos = logPos.m_121945_(opposite);
                boolean tooClose = false;
                for (BlockPos branch : placedBranches) {
                    if (branch.m_123341_() != targetPos.m_123341_() || branch.m_123343_() != targetPos.m_123343_() || Math.abs(branch.m_123342_() - targetPos.m_123342_()) > 3) continue;
                    tooClose = true;
                    break;
                }
                if (tooClose || !context.m_226059_(targetPos)) continue;
                BlockState log = (BlockState)this.logProvider.m_213972_(random, targetPos).m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)dir.m_122434_());
                context.m_226061_(targetPos, log);
                placedBranches.add(targetPos);
            }
        }
    }
}

