/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.world.feature.trunkplacer;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.mcreator.redev.custom.init.RedevModTrunkTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class ChorusTrunkPlacer
extends TrunkPlacer {
    public static final Codec<ChorusTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> ChorusTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, ChorusTrunkPlacer::new));

    public ChorusTrunkPlacer(int baseHeight, int heightRandA, int heightRandB) {
        super(baseHeight, heightRandA, heightRandB);
    }

    protected TrunkPlacerType<?> m_7362_() {
        return (TrunkPlacerType)RedevModTrunkTypes.CHORUS_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> m_213934_(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, int height, BlockPos pos, TreeConfiguration config) {
        ArrayList<FoliagePlacer.FoliageAttachment> foliage = new ArrayList<FoliagePlacer.FoliageAttachment>();
        for (int y = 0; y < height; ++y) {
            int radius = y == height - 1 ? 1 : 2;
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    if (radius == 2 && Math.abs(dx) == 2 && Math.abs(dz) == 2) continue;
                    BlockPos trunkPos = pos.m_7918_(dx, y, dz);
                    this.m_226187_(level, blockSetter, random, trunkPos, config);
                }
            }
        }
        ArrayList<BlockPos> branchStarts = new ArrayList<BlockPos>();
        for (int y = (int)((double)height - (double)height * 0.3); y < height; ++y) {
            int radius = y == height - 1 ? 1 : 2;
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    boolean isEdge;
                    boolean bl = radius == 1 ? Math.abs(dx) == 1 || Math.abs(dz) == 1 : (isEdge = Math.abs(dx) == 2 || Math.abs(dz) == 2);
                    if (!isEdge) continue;
                    BlockPos blockPos = pos.m_7918_(dx, y, dz);
                    branchStarts.add(blockPos);
                }
            }
        }
        int sectorCount = 8;
        ArrayList sectors = new ArrayList(sectorCount);
        for (int i = 0; i < sectorCount; ++i) {
            sectors.add(new ArrayList());
        }
        for (BlockPos start : branchStarts) {
            double dx = start.m_123341_() - pos.m_123341_();
            double dz = start.m_123343_() - pos.m_123343_();
            double angle = Math.atan2(dz, dx);
            if (angle < 0.0) {
                angle += Math.PI * 2;
            }
            int sector = (int)(angle / (Math.PI * 2) * (double)sectorCount);
            ((List)sectors.get(sector)).add(start);
        }
        int maxBranches = 4 + random.m_188503_(5);
        int placed = 0;
        for (List list : sectors) {
            double zDir;
            BlockPos origin;
            double xDir;
            double length;
            if (list.isEmpty() || (length = Math.sqrt((xDir = (double)((origin = (BlockPos)list.get(random.m_188503_(list.size()))).m_123341_() - pos.m_123341_())) * xDir + (zDir = (double)(origin.m_123343_() - pos.m_123343_())) * zDir)) == 0.0) continue;
            xDir /= length;
            zDir /= length;
            BlockPos current = origin;
            int steps = 2 + random.m_188503_(2);
            for (int step = 0; step < steps; ++step) {
                int xi = Mth.m_14107_((double)(xDir * (double)(step + 1)));
                int zi = Mth.m_14107_((double)(zDir * (double)(step + 1)));
                int yi = step + 1;
                BlockPos next = origin.m_7918_(xi, yi, zi);
                BlockPos support = next.m_7495_();
                this.m_226187_(level, blockSetter, random, support, config);
                this.m_226187_(level, blockSetter, random, next, config);
                current = next;
            }
            foliage.add(new FoliagePlacer.FoliageAttachment(current.m_7494_(), 0, false));
            if (++placed < maxBranches) continue;
            break;
        }
        return foliage;
    }
}

