/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.block;

import javax.annotation.Nullable;
import net.mcreator.redev.init.RedevModBlocks;
import net.mcreator.redev.init.RedevModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.IPlantable;

public class CornCropBlock
extends DoublePlantBlock
implements BonemealableBlock {
    public static final IntegerProperty AGE = IntegerProperty.m_61631_((String)"age", (int)0, (int)6);
    public static final int MAX_AGE = 6;

    public CornCropBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60918_(SoundType.f_56740_).m_60966_().m_60910_().m_222979_(BlockBehaviour.OffsetType.XZ).m_278166_(PushReaction.DESTROY));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)f_52858_, (Comparable)DoubleBlockHalf.LOWER));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{AGE});
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockPos basePos = state.m_61143_((Property)f_52858_) == DoubleBlockHalf.UPPER ? pos.m_7495_() : pos;
        BlockState baseState = level.m_8055_(basePos);
        int age = (Integer)baseState.m_61143_((Property)AGE);
        if (age == 6) {
            ItemStack drop = new ItemStack((ItemLike)RedevModItems.CORN.get());
            Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)drop);
            level.m_5594_(null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 1.0f);
            BlockState newBaseState = (BlockState)baseState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(5));
            level.m_7731_(basePos, newBaseState, 2);
            BlockPos upperPos = basePos.m_7494_();
            BlockState upperState = level.m_8055_(upperPos);
            if (CornCropBlock.isUpper(upperState)) {
                BlockState newUpperState = (BlockState)upperState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(5));
                level.m_7731_(upperPos, newUpperState, 2);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private boolean isMaxAge(BlockState state) {
        return (Integer)state.m_61143_((Property)AGE) >= 6;
    }

    public boolean m_6724_(BlockState state) {
        return state.m_61143_((Property)f_52858_) == DoubleBlockHalf.LOWER && !this.isMaxAge(state);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return this.m_49966_();
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        return !state.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : state;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        if (!CornCropBlock.isLower(state)) {
            return super.m_7898_(state, level, pos);
        }
        BlockPos below = pos.m_7495_();
        boolean isSoil = this.m_6266_(level.m_8055_(below), (BlockGetter)level, below);
        if (state.m_60734_() == this) {
            isSoil = level.m_8055_(below).canSustainPlant((BlockGetter)level, below, Direction.UP, (IPlantable)this);
        }
        return isSoil && CornCropBlock.sufficientLight(level, pos) && ((Integer)state.m_61143_((Property)AGE) < 3 || CornCropBlock.isUpper(level.m_8055_(pos.m_7494_())));
    }

    protected boolean m_6266_(BlockState state, BlockGetter level, BlockPos pos) {
        return state.m_60713_(Blocks.f_50093_);
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity instanceof Ravager && level.m_46469_().m_46207_(GameRules.f_46132_)) {
            level.m_46953_(pos, true, entity);
        }
        super.m_7892_(state, level, pos, entity);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        return false;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        float f = this.getGrowthSpeed((BlockGetter)level, pos);
        if (random.m_188503_((int)(25.0f / f) + 1) == 0) {
            this.grow(level, state, pos, 1);
        }
    }

    private float getGrowthSpeed(BlockGetter level, BlockPos pos) {
        BlockPos below = pos.m_7495_();
        BlockState soil = level.m_8055_(below);
        float speed = soil.m_60734_().isFertile(soil, level, below) ? 3.0f : 1.0f;
        for (BlockPos offset : BlockPos.m_121940_((BlockPos)pos.m_7918_(-1, 0, -1), (BlockPos)pos.m_7918_(1, 0, 1))) {
            BlockState state;
            if (offset.equals((Object)pos) || (state = level.m_8055_(offset)).m_60734_() != this) continue;
            speed += 0.25f;
        }
        return speed;
    }

    private void grow(ServerLevel level, BlockState state, BlockPos pos, int increment) {
        int newAge = Math.min((Integer)state.m_61143_((Property)AGE) + increment, 6);
        if (this.canGrow((LevelReader)level, pos, state, newAge)) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(newAge)), 2);
            if (newAge >= 3) {
                BlockPos upperPos = pos.m_7494_();
                level.m_7731_(upperPos, CornCropBlock.m_182453_((LevelReader)level, (BlockPos)pos, (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(newAge))).m_61124_((Property)f_52858_, (Comparable)DoubleBlockHalf.UPPER))), 3);
            }
        }
    }

    private static boolean canGrowInto(LevelReader level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        return state.m_60795_() || state.m_60713_((Block)RedevModBlocks.CORN_CROP.get());
    }

    private static boolean sufficientLight(LevelReader level, BlockPos pos) {
        return level.m_45524_(pos, 0) >= 8 || level.m_45527_(pos);
    }

    private static boolean isLower(BlockState state) {
        return state.m_60713_((Block)RedevModBlocks.CORN_CROP.get()) && state.m_61143_((Property)f_52858_) == DoubleBlockHalf.LOWER;
    }

    private static boolean isUpper(BlockState state) {
        return state.m_60713_((Block)RedevModBlocks.CORN_CROP.get()) && state.m_61143_((Property)f_52858_) == DoubleBlockHalf.UPPER;
    }

    private boolean canGrow(LevelReader level, BlockPos pos, BlockState state, int newAge) {
        return !this.isMaxAge(state) && CornCropBlock.sufficientLight(level, pos) && (newAge < 3 || CornCropBlock.canGrowInto(level, pos.m_7494_()));
    }

    @Nullable
    private PosAndState getLowerHalf(LevelReader level, BlockPos pos, BlockState state) {
        if (CornCropBlock.isLower(state)) {
            return new PosAndState(pos, state);
        }
        BlockPos below = pos.m_7495_();
        BlockState belowState = level.m_8055_(below);
        return CornCropBlock.isLower(belowState) ? new PosAndState(below, belowState) : null;
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        PosAndState base = this.getLowerHalf(level, pos, state);
        return base != null && this.canGrow(level, base.pos, base.state, (Integer)base.state.m_61143_((Property)AGE) + 1);
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        PosAndState base = this.getLowerHalf((LevelReader)level, pos, state);
        if (base != null) {
            this.grow(level, base.state, base.pos, 1);
        }
    }

    record PosAndState(BlockPos pos, BlockState state) {
    }
}

