/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EnderCheckpointBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final IntegerProperty CHARGES = IntegerProperty.m_61631_((String)"charges", (int)0, (int)1);
    private static final List<Vec3i> RESPAWN_HORIZONTAL_OFFSETS = List.of(new Vec3i(0, 0, -1), new Vec3i(-1, 0, 0), new Vec3i(0, 0, 1), new Vec3i(1, 0, 0), new Vec3i(-1, 0, -1), new Vec3i(1, 0, -1), new Vec3i(-1, 0, 1), new Vec3i(1, 0, 1));
    private static final List<Vec3i> RESPAWN_OFFSETS = new ArrayList<Vec3i>();

    public EnderCheckpointBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_280658_(NoteBlockInstrument.BASEDRUM).m_60918_(SoundType.f_56744_).m_60913_(3.0f, 10.0f).m_60953_(s -> 6).m_60999_().m_60955_().m_278166_(PushReaction.BLOCK).m_60924_((bs, br, bp) -> false));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CHARGES, (Comparable)Integer.valueOf(0)));
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return state.m_60819_().m_76178_();
    }

    public int m_7753_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return EnderCheckpointBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, CHARGES});
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_150930_(Items.f_42545_) && (Integer)state.m_61143_((Property)CHARGES) == 0) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)CHARGES, (Comparable)Integer.valueOf(1)), 3);
            level.m_5594_(null, pos, SoundEvents.f_12376_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        if (!level.f_46443_ && (Integer)state.m_61143_((Property)CHARGES) > 0) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.m_9158_(level.m_46472_(), pos, 0.0f, false, true);
            level.m_5594_(null, pos, SoundEvents.f_12326_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public static Optional<Vec3> findSafeRespawnPosition(EntityType<?> entity, CollisionGetter world, BlockPos pos) {
        Optional<Vec3> first = EnderCheckpointBlock.tryFind(entity, world, pos, true);
        return first.isPresent() ? first : EnderCheckpointBlock.tryFind(entity, world, pos, false);
    }

    private static Optional<Vec3> tryFind(EntityType<?> entity, CollisionGetter world, BlockPos pos, boolean precise) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (Vec3i offset : RESPAWN_OFFSETS) {
            mutable.m_122190_((Vec3i)pos).m_122193_(offset);
            Vec3 location = DismountHelper.m_38441_(entity, (CollisionGetter)world, (BlockPos)mutable, (boolean)precise);
            if (location == null) continue;
            return Optional.of(location);
        }
        return Optional.empty();
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if ((Integer)state.m_61143_((Property)CHARGES) > 0) {
            for (int i = 0; i < 3; ++i) {
                double x = (double)pos.m_123341_() + random.m_188500_();
                double y = (double)pos.m_123342_() + 0.4375;
                double z = (double)pos.m_123343_() + random.m_188500_();
                level.m_6493_((ParticleOptions)ParticleTypes.f_123762_, true, x, y, z, 0.0, 0.01, 0.0);
            }
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        boolean flag = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return super.m_7417_(state, facing, facingState, world, currentPos, facingPos);
    }

    static {
        RESPAWN_OFFSETS.addAll(RESPAWN_HORIZONTAL_OFFSETS);
        RESPAWN_HORIZONTAL_OFFSETS.forEach(offset -> RESPAWN_OFFSETS.add(offset.m_7495_()));
        RESPAWN_HORIZONTAL_OFFSETS.forEach(offset -> RESPAWN_OFFSETS.add(offset.m_7494_()));
        RESPAWN_OFFSETS.add(new Vec3i(0, 1, 0));
    }
}

