/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.block;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.function.ToIntFunction;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SoulCandleBlock
extends CandleBlock {
    public static final ToIntFunction<BlockState> LIGHT_EMISSION = blockstate -> (Boolean)blockstate.m_61143_((Property)f_152791_) != false ? 2 * (Integer)blockstate.m_61143_((Property)f_152790_) : 0;
    private static final Int2ObjectMap<List<Vec3>> PARTICLE_OFFSETS = (Int2ObjectMap)Util.m_137537_(() -> {
        Int2ObjectOpenHashMap int2objectmap = new Int2ObjectOpenHashMap();
        int2objectmap.defaultReturnValue((Object)ImmutableList.of());
        int2objectmap.put(1, (Object)ImmutableList.of((Object)new Vec3(0.5, 0.625, 0.5)));
        int2objectmap.put(2, (Object)ImmutableList.of((Object)new Vec3(0.3125, 0.5, 0.625), (Object)new Vec3(0.6875, 0.625, 0.375)));
        int2objectmap.put(3, (Object)ImmutableList.of((Object)new Vec3(0.3125, 0.5, 0.4375), (Object)new Vec3(0.5625, 0.375, 0.6875), (Object)new Vec3(0.6875, 0.625, 0.3125)));
        int2objectmap.put(4, (Object)ImmutableList.of((Object)new Vec3(0.25, 0.5, 0.375), (Object)new Vec3(0.375, 0.375, 0.6875), (Object)new Vec3(0.75, 0.5, 0.625), (Object)new Vec3(0.625, 0.625, 0.3125)));
        return Int2ObjectMaps.unmodifiable((Int2ObjectMap)int2objectmap);
    });
    private static final VoxelShape ONE_AABB = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)8.0, (double)10.0);
    private static final VoxelShape TWO_AABB = Block.m_49796_((double)3.0, (double)0.0, (double)4.0, (double)13.0, (double)8.0, (double)12.0);
    private static final VoxelShape THREE_AABB = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0);
    private static final VoxelShape FOUR_AABB = Block.m_49796_((double)2.0, (double)0.0, (double)3.0, (double)14.0, (double)8.0, (double)13.0);

    public SoulCandleBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_154653_).m_60978_(0.4f).m_60955_().m_60953_(LIGHT_EMISSION::applyAsInt));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_152790_, (Comparable)Integer.valueOf(1))).m_61124_((Property)f_152791_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_152792_, (Comparable)Boolean.valueOf(false)));
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)f_152791_)).booleanValue()) {
            for (Vec3 offset : this.m_142199_(state)) {
                Vec3 vec = offset.m_82520_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                SoulCandleBlock.addParticles(level, vec, level.m_213780_());
            }
        }
    }

    public static void addParticles(Level level, Vec3 vec, RandomSource random) {
        float f = random.m_188501_();
        if (f < 0.3f) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123746_, vec.f_82479_, vec.f_82480_, vec.f_82481_, 0.0, 0.0, 0.0);
            if (f < 0.17f) {
                level.m_7785_(vec.f_82479_ + 0.5, vec.f_82480_ + 0.5, vec.f_82481_ + 0.5, SoundEvents.f_144096_, SoundSource.BLOCKS, 1.0f + random.m_188501_(), random.m_188501_() * 0.7f + 0.3f, false);
            }
        }
        level.m_7106_((ParticleOptions)ParticleTypes.f_123745_, vec.f_82479_, vec.f_82480_, vec.f_82481_, 0.0, 0.0, 0.0);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int candleCount = (Integer)state.m_61143_((Property)f_152790_);
        return switch (candleCount) {
            case 2 -> TWO_AABB;
            case 3 -> THREE_AABB;
            case 4 -> FOUR_AABB;
            default -> ONE_AABB;
        };
    }

    protected Iterable<Vec3> m_142199_(BlockState state) {
        return (Iterable)PARTICLE_OFFSETS.get((Object)state.m_61143_((Property)f_152790_));
    }
}

