/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.block.entity;

import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.mcreator.redev.block.CrucibleBlock;
import net.mcreator.redev.init.RedevModBlockEntities;
import net.mcreator.redev.world.inventory.CrucibleMenuMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class CrucibleBlockEntity
extends RandomizableContainerBlockEntity
implements WorldlyContainer,
MenuProvider {
    private int smeltTicks = 0;
    private int remainingFuel = 0;
    private NonNullList<ItemStack> stacks = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
    private final LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])Direction.values());
    private final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> CrucibleBlockEntity.this.smeltTicks;
                case 1 -> CrucibleBlockEntity.this.remainingFuel;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    CrucibleBlockEntity.this.smeltTicks = value;
                    break;
                }
                case 1: {
                    CrucibleBlockEntity.this.remainingFuel = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };

    public CrucibleBlockEntity(BlockPos position, BlockState state) {
        super((BlockEntityType)RedevModBlockEntities.CRUCIBLE.get(), position, state);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.smeltTicks = compound.m_128451_("SmeltTicks");
        this.remainingFuel = compound.m_128451_("Fuel");
        if (!this.m_59631_(compound)) {
            this.stacks = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        }
        ContainerHelper.m_18980_((CompoundTag)compound, this.stacks);
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("SmeltTicks", this.smeltTicks);
        compound.m_128405_("Fuel", this.remainingFuel);
        if (!this.m_59634_(compound)) {
            ContainerHelper.m_18973_((CompoundTag)compound, this.stacks);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public int m_6643_() {
        return this.stacks.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.stacks) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public Component m_6820_() {
        return Component.m_237113_((String)"crucible");
    }

    public int m_6893_() {
        return 64;
    }

    public AbstractContainerMenu m_6555_(int id, Inventory inventory) {
        return new CrucibleMenuMenu(id, inventory, this);
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"Crucible");
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.stacks;
    }

    protected void m_6520_(NonNullList<ItemStack> stacks) {
        this.stacks = stacks;
    }

    public boolean m_7013_(int index, ItemStack stack) {
        if (index == 0) {
            return this.canSmelt(stack);
        }
        if (index == 1) {
            return stack.m_150930_(Items.f_42448_);
        }
        return false;
    }

    public int[] m_7071_(Direction side) {
        return IntStream.range(0, this.m_6643_()).toArray();
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return index != 1;
    }

    public boolean m_7155_(int index, ItemStack stack, @Nullable Direction direction) {
        return this.m_7013_(index, stack);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, CrucibleBlockEntity be) {
        ServerLevel serverLevel;
        boolean wasFilled;
        if (level.f_46443_) {
            return;
        }
        ItemStack input = (ItemStack)be.stacks.get(0);
        ItemStack fuel = (ItemStack)be.stacks.get(1);
        ItemStack output = (ItemStack)be.stacks.get(2);
        boolean canSmelt = be.canSmelt(input);
        boolean hasFuel = be.remainingFuel > 0 || !fuel.m_41619_() && fuel.m_150930_(Items.f_42448_);
        if (hasFuel != (wasFilled = ((Boolean)state.m_61143_((Property)CrucibleBlock.FILLED)).booleanValue())) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)CrucibleBlock.FILLED, (Comparable)Boolean.valueOf(hasFuel)), 3);
        }
        if (hasFuel && level instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            if (level.f_46441_.m_188501_() < 0.01f) {
                serverLevel.m_5594_(null, pos, SoundEvents.f_12030_, SoundSource.BLOCKS, 0.5f, 1.0f);
            }
        }
        if (canSmelt && hasFuel) {
            ItemStack result;
            if (be.remainingFuel <= 0 && fuel.m_150930_(Items.f_42448_)) {
                fuel.m_41774_(1);
                be.stacks.set(1, (Object)(fuel.m_41619_() ? ItemStack.f_41583_ : fuel));
                be.remainingFuel = 4;
            }
            ++be.smeltTicks;
            if (level instanceof ServerLevel) {
                serverLevel = (ServerLevel)level;
                if (be.smeltTicks > 0 && level.f_46441_.m_188501_() < 0.25f) {
                    double px = (double)pos.m_123341_() + 0.5 + (level.f_46441_.m_188500_() - 0.5) * 0.3;
                    double py = (double)pos.m_123342_() + 0.8;
                    double pz = (double)pos.m_123343_() + 0.5 + (level.f_46441_.m_188500_() - 0.5) * 0.3;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, px, py, pz, 1, 0.0, 0.015, 0.0, 0.0);
                }
            }
            if (be.smeltTicks >= 100 && !(result = be.getSmeltResult(input)).m_41619_()) {
                input.m_41774_(1);
                --be.remainingFuel;
                be.smeltTicks = 0;
                if (output.m_41619_()) {
                    be.stacks.set(2, (Object)result.m_41777_());
                } else if (ItemStack.m_150942_((ItemStack)output, (ItemStack)result)) {
                    output.m_41769_(result.m_41613_());
                }
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel2 = (ServerLevel)level;
                    serverLevel2.m_5594_(null, pos, SoundEvents.f_12031_, SoundSource.BLOCKS, 0.6f, 0.9f + level.f_46441_.m_188501_() * 0.2f);
                }
                be.m_6596_();
                level.m_7260_(pos, state, state, 3);
            }
        } else {
            be.smeltTicks = 0;
        }
    }

    private ItemStack getSmeltResult(ItemStack input) {
        if (input.m_41619_() || input.m_41776_() <= 0) {
            return ItemStack.f_41583_;
        }
        Item item = input.m_41720_();
        int currentDamage = input.m_41773_();
        boolean isFullDurability = currentDamage == 0;
        int amount = 0;
        if (item == Items.f_42383_ || item == Items.f_42387_) {
            amount = isFullDurability ? 2 : 1 + this.f_58857_.f_46441_.m_188503_(2);
        } else if (item == Items.f_42385_ || item == Items.f_42386_) {
            amount = isFullDurability ? 3 : 1 + this.f_58857_.f_46441_.m_188503_(3);
        } else if (item == Items.f_42384_) {
            amount = 1;
        } else if (item == Items.f_42468_) {
            amount = isFullDurability ? 5 : 3 + this.f_58857_.f_46441_.m_188503_(3);
        } else if (item == Items.f_42469_) {
            amount = isFullDurability ? 8 : 4 + this.f_58857_.f_46441_.m_188503_(5);
        } else if (item == Items.f_42470_) {
            amount = isFullDurability ? 7 : 3 + this.f_58857_.f_46441_.m_188503_(5);
        } else if (item == Items.f_42471_) {
            int n = amount = isFullDurability ? 4 : 1 + this.f_58857_.f_46441_.m_188503_(4);
        }
        if (amount > 0) {
            return new ItemStack((ItemLike)Items.f_42416_, amount);
        }
        if (item == Items.f_42430_ || item == Items.f_42434_) {
            amount = isFullDurability ? 2 : 1 + this.f_58857_.f_46441_.m_188503_(2);
        } else if (item == Items.f_42432_ || item == Items.f_42433_) {
            amount = isFullDurability ? 3 : 1 + this.f_58857_.f_46441_.m_188503_(3);
        } else if (item == Items.f_42431_) {
            amount = 1;
        } else if (item == Items.f_42476_) {
            amount = isFullDurability ? 5 : 3 + this.f_58857_.f_46441_.m_188503_(3);
        } else if (item == Items.f_42477_) {
            amount = isFullDurability ? 8 : 4 + this.f_58857_.f_46441_.m_188503_(5);
        } else if (item == Items.f_42478_) {
            amount = isFullDurability ? 7 : 3 + this.f_58857_.f_46441_.m_188503_(5);
        } else if (item == Items.f_42479_) {
            int n = amount = isFullDurability ? 4 : 1 + this.f_58857_.f_46441_.m_188503_(4);
        }
        if (amount > 0) {
            return new ItemStack((ItemLike)Items.f_42417_, amount);
        }
        if (item == Items.f_42388_ || item == Items.f_42392_) {
            amount = isFullDurability ? 2 : 1 + this.f_58857_.f_46441_.m_188503_(2);
        } else if (item == Items.f_42390_ || item == Items.f_42391_) {
            amount = isFullDurability ? 3 : 1 + this.f_58857_.f_46441_.m_188503_(3);
        } else if (item == Items.f_42389_) {
            amount = 1;
        } else if (item == Items.f_42472_) {
            amount = isFullDurability ? 5 : 3 + this.f_58857_.f_46441_.m_188503_(3);
        } else if (item == Items.f_42473_) {
            amount = isFullDurability ? 8 : 4 + this.f_58857_.f_46441_.m_188503_(5);
        } else if (item == Items.f_42474_) {
            amount = isFullDurability ? 7 : 3 + this.f_58857_.f_46441_.m_188503_(5);
        } else if (item == Items.f_42475_) {
            int n = amount = isFullDurability ? 4 : 1 + this.f_58857_.f_46441_.m_188503_(4);
        }
        if (amount > 0) {
            return new ItemStack((ItemLike)Items.f_42415_, amount);
        }
        if (item == Items.f_42393_ || item == Items.f_42397_ || item == Items.f_42395_ || item == Items.f_42396_ || item == Items.f_42394_ || item == Items.f_42480_ || item == Items.f_42481_ || item == Items.f_42482_ || item == Items.f_42483_) {
            return new ItemStack((ItemLike)Items.f_42418_, 1);
        }
        return ItemStack.f_41583_;
    }

    private boolean canSmelt(ItemStack input) {
        return !this.getSmeltResult(input).m_41619_();
    }

    public ContainerData getDataAccess() {
        return this.data;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.handlers[facing.ordinal()].cast();
        }
        return super.getCapability(capability, facing);
    }

    public void m_7651_() {
        super.m_7651_();
        for (LazyOptional<? extends IItemHandler> handler : this.handlers) {
            handler.invalidate();
        }
    }
}

