/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mcreator.redev.entity.RedstoneGolemEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class Modelredstone_golem<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("redev", "modelredstone_golem"), "main");
    public final ModelPart bone;
    public final ModelPart head;
    public final ModelPart body;
    public final ModelPart redstone;
    public final ModelPart left_arm;
    public final ModelPart left_arm_below;
    public final ModelPart right_arm;
    public final ModelPart right_arm_below;
    public final ModelPart left_leg;
    public final ModelPart right_leg;

    public Modelredstone_golem(ModelPart root) {
        this.bone = root.m_171324_("bone");
        this.head = this.bone.m_171324_("head");
        this.body = this.bone.m_171324_("body");
        this.redstone = this.body.m_171324_("redstone");
        this.left_arm = this.bone.m_171324_("left_arm");
        this.left_arm_below = this.left_arm.m_171324_("left_arm_below");
        this.right_arm = this.bone.m_171324_("right_arm");
        this.right_arm_below = this.right_arm.m_171324_("right_arm_below");
        this.left_leg = root.m_171324_("left_leg");
        this.right_leg = root.m_171324_("right_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition bone = partdefinition.m_171599_("bone", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)2.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition head = bone.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-8.0f, -8.0f, -12.0f, 16.0f, 16.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-28.0f, (float)-10.0f));
        PartDefinition body = bone.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 28).m_171488_(-20.0f, -8.0f, 0.0f, 40.0f, 32.0f, 20.0f, new CubeDeformation(0.0f)).m_171514_(64, 116).m_171488_(-11.0f, 24.0f, 3.0f, 22.0f, 8.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-28.0f, (float)-10.0f));
        PartDefinition redstone = body.m_171599_("redstone", CubeListBuilder.m_171558_().m_171514_(0, 116).m_171488_(23.0f, -16.0f, -1.0f, 16.0f, 16.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-31.0f, (float)20.0f, (float)11.0f));
        PartDefinition left_arm = bone.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(0, 80).m_171480_().m_171488_(0.0f, -4.0f, -7.0f, 14.0f, 24.0f, 12.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)20.0f, (float)-29.0f, (float)2.0f));
        PartDefinition left_arm_below = left_arm.m_171599_("left_arm_below", CubeListBuilder.m_171558_().m_171514_(52, 80).m_171480_().m_171488_(-4.0f, 0.0f, -6.0f, 12.0f, 22.0f, 12.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)9.0f, (float)20.0f, (float)-1.0f));
        PartDefinition cube_r1 = left_arm_below.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(88, 80).m_171488_(-2.5f, -4.0f, -1.0f, 5.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.5f, (float)25.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition cube_r2 = left_arm_below.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(88, 80).m_171480_().m_171488_(-2.5f, -4.0f, -1.0f, 5.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)2.5f, (float)26.0f, (float)3.5f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition cube_r3 = left_arm_below.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(88, 80).m_171480_().m_171488_(-2.5f, -4.0f, -1.0f, 5.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)2.5f, (float)26.0f, (float)-3.5f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition right_arm = bone.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(0, 80).m_171488_(-14.0f, -4.0f, -7.0f, 14.0f, 24.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-20.0f, (float)-29.0f, (float)2.0f));
        PartDefinition right_arm_below = right_arm.m_171599_("right_arm_below", CubeListBuilder.m_171558_().m_171514_(52, 80).m_171488_(-8.0f, 0.0f, -6.0f, 12.0f, 22.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-9.0f, (float)20.0f, (float)-1.0f));
        PartDefinition cube_r4 = right_arm_below.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(88, 80).m_171480_().m_171488_(-2.5f, -4.0f, -1.0f, 5.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)1.5f, (float)25.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition cube_r5 = right_arm_below.m_171599_("cube_r5", CubeListBuilder.m_171558_().m_171514_(88, 80).m_171488_(-2.5f, -4.0f, -1.0f, 5.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.5f, (float)26.0f, (float)3.5f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition cube_r6 = right_arm_below.m_171599_("cube_r6", CubeListBuilder.m_171558_().m_171514_(88, 80).m_171488_(-2.5f, -4.0f, -1.0f, 5.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.5f, (float)26.0f, (float)-3.5f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition left_leg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(100, 80).m_171480_().m_171488_(-6.0f, 0.0f, -6.0f, 12.0f, 20.0f, 12.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)11.0f, (float)4.0f, (float)2.0f));
        PartDefinition right_leg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(100, 80).m_171488_(-6.0f, 0.0f, -6.0f, 12.0f, 20.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-11.0f, (float)4.0f, (float)2.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)256, (int)256);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.bone.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.left_leg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.right_leg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void m_6839_(T entity, float limbSwing, float limbSwingAmount, float partialTicks) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            int attackTick = 0;
            if (living instanceof RedstoneGolemEntity) {
                RedstoneGolemEntity golem = (RedstoneGolemEntity)living;
                attackTick = golem.getAttackAnimationTick();
            }
            if (attackTick > 0) {
                float swing;
                this.left_arm.f_104203_ = swing = -2.0f + 1.5f * Mth.m_14156_((float)((float)attackTick - partialTicks), (float)10.0f);
                this.right_arm.f_104203_ = swing;
            } else {
                float armBackBend = (float)Math.toRadians(15.0);
                this.left_arm.f_104203_ = armBackBend + Mth.m_14089_((float)(limbSwing * 0.6662f)) * limbSwingAmount;
                this.right_arm.f_104203_ = armBackBend + Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
            }
        }
    }

    public void m_6973_(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        RedstoneGolemEntity golem2;
        RedstoneGolemEntity golem;
        if (entity instanceof RedstoneGolemEntity && (golem = (RedstoneGolemEntity)((Object)entity)).isPreparingMineSummon()) {
            this.bone.f_104203_ = (float)Math.toRadians(60.0);
            this.bone.f_104205_ = 0.0f;
            this.head.f_104204_ = netHeadYaw / 57.295776f;
            this.head.f_104203_ = (float)Math.toRadians(17.5) - this.bone.f_104203_;
            this.left_arm.f_104203_ = (float)Math.toRadians(-25.0);
            this.right_arm.f_104203_ = (float)Math.toRadians(-25.0);
            this.left_arm_below.f_104203_ = (float)Math.toRadians(-35.0);
            this.right_arm_below.f_104203_ = (float)Math.toRadians(-35.0);
            float bobSpeed = 0.3f;
            float bobAmount = 1.5f;
            this.redstone.f_104202_ = 11.0f + Mth.m_14031_((float)(ageInTicks * bobSpeed)) * bobAmount;
            this.left_leg.f_104203_ = 0.0f;
            this.left_leg.f_104201_ = 4.0f;
            this.left_leg.f_104202_ = 2.0f;
            this.right_leg.f_104203_ = 0.0f;
            this.right_leg.f_104201_ = 4.0f;
            this.right_leg.f_104202_ = 2.0f;
            return;
        }
        float swingSpeed = 0.1f;
        float walkBase = (float)Math.toRadians(20.0);
        float walkAmp = (float)Math.toRadians(5.0);
        float idleBase = (float)Math.toRadians(16.5);
        float idleAmp = (float)Math.toRadians(1.5);
        this.bone.f_104203_ = limbSwingAmount > 0.1f ? walkBase + Mth.m_14089_((float)(ageInTicks * swingSpeed)) * walkAmp : idleBase + Mth.m_14089_((float)(ageInTicks * swingSpeed)) * idleAmp;
        if (limbSwingAmount > 0.1f) {
            float rollAmp = (float)Math.toRadians(5.0);
            this.bone.f_104205_ = Mth.m_14031_((float)(limbSwing * 0.6662f)) * rollAmp * limbSwingAmount;
        } else {
            this.bone.f_104205_ = 0.0f;
        }
        this.head.f_104204_ = netHeadYaw / 57.295776f;
        this.head.f_104203_ = headPitch / 57.295776f - this.bone.f_104203_;
        if (entity instanceof RedstoneGolemEntity && (golem2 = (RedstoneGolemEntity)((Object)entity)).getAttackAnimationTick() > 0) {
            this.left_arm_below.f_104203_ = -walkBase;
            this.right_arm_below.f_104203_ = -walkBase;
        } else {
            this.left_arm_below.f_104203_ = -(this.bone.f_104203_ + this.left_arm.f_104203_) - walkBase;
            this.right_arm_below.f_104203_ = -(this.bone.f_104203_ + this.right_arm.f_104203_) - walkBase;
        }
        float legTiltAmplitude = (float)Math.toRadians(10.0);
        float swingCos = Mth.m_14089_((float)(limbSwing * 0.6662f));
        float swingSin = Mth.m_14031_((float)(limbSwing * 0.6662f));
        float legYAmplitude = 5.0f;
        float leftLegY = Math.max(0.0f, swingSin) * legYAmplitude * limbSwingAmount;
        float rightLegY = Math.max(0.0f, -swingSin) * legYAmplitude * limbSwingAmount;
        this.left_leg.f_104201_ = 4.0f - leftLegY;
        this.right_leg.f_104201_ = 4.0f - rightLegY;
        float zOffset = 2.0f;
        float legZAmplitude = 10.0f;
        this.left_leg.f_104202_ = zOffset + swingCos * legZAmplitude;
        this.right_leg.f_104202_ = zOffset - swingCos * legZAmplitude;
        float leftLegSwing = swingCos * -1.0f * limbSwingAmount;
        float rightLegSwing = swingCos * 1.0f * limbSwingAmount;
        float leftLegTilt = swingSin * legTiltAmplitude * limbSwingAmount;
        float rightLegTilt = -swingSin * legTiltAmplitude * limbSwingAmount;
    }
}

