/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.custom;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class VoidFogFeature {
    private static final int FOG_START_Y = 64;
    private static final int FOG_END_Y = 112;

    @SubscribeEvent
    public static void onFogDensity(ViewportEvent.RenderFog event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        ClientLevel level = mc.f_91073_;
        if (level == null || player == null) {
            return;
        }
        if (player.m_21023_(MobEffects.f_19611_)) {
            return;
        }
        if (!level.m_204156_().m_203565_(BuiltinDimensionTypes.f_223538_)) {
            return;
        }
        double y = VoidFogFeature.getAverageDepth((LivingEntity)player);
        event.setFarPlaneDistance((float)VoidFogFeature.blendLog(event.getFarPlaneDistance(), 16.0, y, 64.0, 112.0, 200.0));
        event.setNearPlaneDistance((float)VoidFogFeature.blendLog(event.getNearPlaneDistance(), 8.0, y, 64.0, 112.0, 200.0));
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onFogColor(ViewportEvent.ComputeFogColor event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        ClientLevel level = mc.f_91073_;
        if (level == null || player == null) {
            return;
        }
        if (player.m_21023_(MobEffects.f_19611_)) {
            return;
        }
        if (!level.m_204156_().m_203565_(BuiltinDimensionTypes.f_223538_)) {
            return;
        }
        double y = VoidFogFeature.getAverageDepth((LivingEntity)player);
        event.setRed((float)VoidFogFeature.blendLog(event.getRed(), 0.0, y, 64.0, 102.0, 200.0));
        event.setGreen((float)VoidFogFeature.blendLog(event.getGreen(), 0.0, y, 64.0, 102.0, 200.0));
        event.setBlue((float)VoidFogFeature.blendLog(event.getBlue(), 0.0, y, 64.0, 102.0, 200.0));
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        ClientLevel level = mc.f_91073_;
        if (level == null || player == null || mc.m_91104_()) {
            return;
        }
        if (player.m_21023_(MobEffects.f_19611_)) {
            return;
        }
        if (!level.m_204156_().m_203565_(BuiltinDimensionTypes.f_223538_)) {
            return;
        }
        double y = VoidFogFeature.getAverageDepth((LivingEntity)player);
        int particles = (int)VoidFogFeature.blend(0.0, 5.0, y, 102.0, 64.0);
        for (int i = 0; i < particles; ++i) {
            double x = player.m_20185_() + (double)level.f_46441_.m_216332_(-16, 16);
            double yPos = player.m_20186_() + (double)level.f_46441_.m_216332_(-10, 10);
            double z = player.m_20189_() + (double)level.f_46441_.m_216332_(-16, 16);
            level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123814_, Blocks.f_49994_.m_49966_()), x, yPos, z, 0.0, 0.0, 0.0);
        }
    }

    private static double blend(double from, double to, double factor, double min, double max) {
        if (factor <= min) {
            return from;
        }
        if (factor >= max) {
            return to;
        }
        return (to - from) / (max - min) * (factor - min) + from;
    }

    private static double blendLog(double from, double to, double factor, double min, double max, double intensity) {
        factor = VoidFogFeature.clamp(factor, min, max);
        double norm = (factor - min) / (max - min);
        double log = Math.log(intensity * norm + 1.0) / Math.log(intensity + 1.0);
        return from + (to - from) * log;
    }

    private static double clamp(double val, double min, double max) {
        return Math.max(min, Math.min(max, val));
    }

    private static double getAverageDepth(LivingEntity entity) {
        double depth = 0.0;
        List<BlockPos> samples = VoidFogFeature.getPositionGrid(entity.m_20183_(), 36, 10);
        for (BlockPos pos : samples) {
            double surfaceY = entity.m_9236_().m_6924_(Heightmap.Types.WORLD_SURFACE, pos.m_123341_(), pos.m_123343_());
            depth += surfaceY - entity.m_20186_();
        }
        return depth / (double)samples.size();
    }

    private static List<BlockPos> getPositionGrid(BlockPos pos, int samples, int interval) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        int root = (int)Math.sqrt(samples);
        int radius = root * interval / 2;
        for (int x = -radius; x < radius; x += interval) {
            for (int z = -radius; z < radius; z += interval) {
                list.add(pos.m_7918_(x + interval / 2, 0, z + interval / 2));
            }
        }
        return list;
    }
}

