/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.enchantment;

import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BacklashEnchantment
extends Enchantment {
    public BacklashEnchantment() {
        super(Enchantment.Rarity.UNCOMMON, EnchantmentCategory.BREAKABLE, new EquipmentSlot[]{EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND});
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public int m_6586_() {
        return 3;
    }

    public boolean canApplyAtEnchantingTable(ItemStack itemstack) {
        return itemstack.m_41720_() instanceof ShieldItem;
    }

    public boolean m_6591_() {
        return true;
    }

    @SubscribeEvent
    public void onBlockedAttack(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        DamageSource source = event.getSource();
        Entity entity = source.m_7639_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)entity;
        if (!player.m_21254_()) {
            return;
        }
        ItemStack mainHand = player.m_21205_();
        ItemStack offHand = player.m_21206_();
        int level = Math.max(this.getEnchantmentLevel(mainHand), this.getEnchantmentLevel(offHand));
        if (level <= 0) {
            return;
        }
        double knockbackStrength = 1.1 + 0.2 * (double)level;
        Vec3 knockbackDirection = attacker.m_20182_().m_82546_(player.m_20182_()).m_82541_().m_82490_(knockbackStrength);
        attacker.m_20256_(knockbackDirection);
        attacker.f_19812_ = true;
    }

    private int getEnchantmentLevel(ItemStack stack) {
        return stack.m_41720_() instanceof ShieldItem ? stack.getEnchantmentLevel((Enchantment)this) : 0;
    }
}

