/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.enchantment;

import java.util.List;
import java.util.UUID;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class DashEnchantment
extends Enchantment {
    private static final UUID SPRINT_SPEED_MODIFIER = UUID.fromString("d47a1b79-f193-4b71-b6a3-d7e58f7a5e1c");

    public DashEnchantment(EquipmentSlot ... slots) {
        super(Enchantment.Rarity.UNCOMMON, EnchantmentCategory.ARMOR_LEGS, slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public int m_6586_() {
        return 3;
    }

    protected boolean m_5975_(Enchantment ench) {
        return this != ench && !List.of(Enchantments.f_220304_).contains(ench);
    }

    public boolean m_6591_() {
        return true;
    }

    @SubscribeEvent
    public void onLivingTick(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        boolean isSprinting = player.m_20142_();
        int level = player.m_6844_(EquipmentSlot.LEGS).getEnchantmentLevel((Enchantment)this);
        if (level > 0 && isSprinting) {
            double speedBonus = 0.05 * (double)level;
            this.applySprintSpeedBoost(player, speedBonus);
        } else {
            this.removeSprintSpeedBoost(player);
        }
    }

    private void applySprintSpeedBoost(Player player, double amount) {
        AttributeInstance attributeInstance = player.m_21051_(Attributes.f_22279_);
        if (attributeInstance == null) {
            return;
        }
        attributeInstance.m_22120_(SPRINT_SPEED_MODIFIER);
        attributeInstance.m_22118_(new AttributeModifier(SPRINT_SPEED_MODIFIER, "Dash sprint boost", amount, AttributeModifier.Operation.MULTIPLY_TOTAL));
    }

    private void removeSprintSpeedBoost(Player player) {
        AttributeInstance attributeInstance = player.m_21051_(Attributes.f_22279_);
        if (attributeInstance != null) {
            attributeInstance.m_22120_(SPRINT_SPEED_MODIFIER);
        }
    }

    @SubscribeEvent
    public void onEquipmentChange(LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (event.getSlot() == EquipmentSlot.LEGS && (event.getTo() == null || event.getTo().m_41619_() || event.getTo().getEnchantmentLevel((Enchantment)this) == 0)) {
                this.removeSprintSpeedBoost(player);
            }
        }
    }
}

