/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.enchantment;

import java.util.UUID;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ReinforceEnchantment
extends Enchantment {
    private static final UUID ARMOR_BOOST_MODIFIER = UUID.fromString("f407fb9d-b1bd-44ee-b84e-0373e19d015a");

    public ReinforceEnchantment(EquipmentSlot ... slots) {
        super(Enchantment.Rarity.UNCOMMON, EnchantmentCategory.BREAKABLE, slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public int m_6586_() {
        return 3;
    }

    public boolean canApplyAtEnchantingTable(ItemStack itemstack) {
        return itemstack.m_41720_() instanceof ShieldItem;
    }

    @SubscribeEvent
    public void onLivingTick(LivingEvent.LivingTickEvent event) {
        boolean hasEnchantedShield;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        ItemStack mainHand = player.m_21205_();
        ItemStack offHand = player.m_21206_();
        boolean bl = hasEnchantedShield = this.isEnchantedShield(mainHand) || this.isEnchantedShield(offHand);
        if (hasEnchantedShield) {
            int level = Math.max(this.getEnchantmentLevel(mainHand), this.getEnchantmentLevel(offHand));
            this.applyArmorBoost(player, level);
        } else {
            this.removeArmorBoost(player);
        }
    }

    private boolean isEnchantedShield(ItemStack stack) {
        return !stack.m_41619_() && stack.m_41720_() == Items.f_42740_ && stack.getEnchantmentLevel((Enchantment)this) > 0;
    }

    private int getEnchantmentLevel(ItemStack stack) {
        return stack.getEnchantmentLevel((Enchantment)this);
    }

    private void applyArmorBoost(Player player, int level) {
        AttributeInstance attributeInstance = player.m_21051_(Attributes.f_22284_);
        if (attributeInstance == null) {
            return;
        }
        attributeInstance.m_22120_(ARMOR_BOOST_MODIFIER);
        attributeInstance.m_22118_(new AttributeModifier(ARMOR_BOOST_MODIFIER, "Reinforce Armor Boost", 2.0 * (double)level, AttributeModifier.Operation.ADDITION));
    }

    private void removeArmorBoost(Player player) {
        AttributeInstance attributeInstance = player.m_21051_(Attributes.f_22284_);
        if (attributeInstance != null) {
            attributeInstance.m_22120_(ARMOR_BOOST_MODIFIER);
        }
    }

    @SubscribeEvent
    public void onEquipmentChange(LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!(event.getSlot() != EquipmentSlot.MAINHAND && event.getSlot() != EquipmentSlot.OFFHAND || this.isEnchantedShield(event.getTo()))) {
                this.removeArmorBoost(player);
            }
        }
    }
}

