/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.enchantment;

import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SwirlingEnchantment
extends Enchantment {
    public SwirlingEnchantment(EquipmentSlot ... slots) {
        super(Enchantment.Rarity.UNCOMMON, EnchantmentCategory.WEAPON, slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public int m_6586_() {
        return 3;
    }

    public boolean canApplyAtEnchantingTable(ItemStack itemstack) {
        return Ingredient.m_204132_((TagKey)ItemTags.create((ResourceLocation)new ResourceLocation("redev:broadswords"))).test(itemstack);
    }

    protected boolean m_5975_(Enchantment ench) {
        return this != ench && !List.of(Enchantments.f_44983_).contains(ench);
    }

    @SubscribeEvent
    public void onCriticalHit(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        ItemStack weapon = player.m_21205_();
        int level = EnchantmentHelper.m_44843_((Enchantment)this, (ItemStack)weapon);
        if (level <= 0) {
            return;
        }
        if (!(player.f_19789_ > 0.0f) || player.m_20096_() || player.m_20142_()) {
            return;
        }
        float chance = 0.15f + 0.15f * (float)(level - 1);
        if (player.m_217043_().m_188501_() > chance) {
            return;
        }
        LivingEntity target = event.getEntity();
        double damage = event.getAmount();
        double splashDamage = damage * (0.1 + 0.1 * (double)(level - 1));
        double radius = 1.0 + (double)(1 * (level - 1));
        AABB splashArea = new AABB(player.m_20185_() - radius, player.m_20186_() - radius, player.m_20189_() - radius, player.m_20185_() + radius, player.m_20186_() + radius, player.m_20189_() + radius);
        List nearbyMobs = player.m_9236_().m_6443_(LivingEntity.class, splashArea, mob -> mob != target && mob != player);
        for (LivingEntity mob2 : nearbyMobs) {
            mob2.m_6469_(event.getSource(), (float)splashDamage);
        }
    }

    public boolean m_6591_() {
        return true;
    }
}

