/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.enchantment;

import java.util.List;
import net.mcreator.redev.init.RedevModEnchantments;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class WoundingEnchantment
extends Enchantment {
    public WoundingEnchantment(EquipmentSlot ... slots) {
        super(Enchantment.Rarity.UNCOMMON, EnchantmentCategory.WEAPON, slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public int m_6586_() {
        return 3;
    }

    protected boolean m_5975_(Enchantment ench) {
        return this != ench && !List.of(Enchantments.f_44981_, Enchantments.f_44962_, (Enchantment)RedevModEnchantments.LEECHING.get()).contains(ench);
    }

    public boolean canApplyAtEnchantingTable(ItemStack itemstack) {
        return Ingredient.m_204132_((TagKey)ItemTags.create((ResourceLocation)new ResourceLocation("redev:daggers"))).test(itemstack);
    }

    public boolean m_6591_() {
        return true;
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)entity;
        LivingEntity target = event.getEntity();
        if (target == null || target.m_21233_() <= 0.0f) {
            return;
        }
        ItemStack weapon = attacker.m_21205_();
        int level = EnchantmentHelper.m_44843_((Enchantment)this, (ItemStack)weapon);
        if (level > 0) {
            float maxHealth = target.m_21233_();
            float currentHealth = target.m_21223_();
            float healthLostPercentage = (maxHealth - currentHealth) / maxHealth * 100.0f;
            float damageMultiplier = 1.0f + healthLostPercentage * (float)level * 0.01f;
            event.setAmount(event.getAmount() * damageMultiplier);
        }
    }
}

