/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.entity;

import java.util.List;
import net.mcreator.redev.init.RedevModEntities;
import net.mcreator.redev.init.RedevModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.EatBlockGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class ArmadilloEntity
extends Animal {
    private static final EntityDataAccessor<Integer> SCARED_TICK = SynchedEntityData.m_135353_(ArmadilloEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public ArmadilloEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<ArmadilloEntity>)((EntityType)RedevModEntities.ARMADILLO.get()), world);
    }

    public ArmadilloEntity(EntityType<ArmadilloEntity> type, Level world) {
        super(type, world);
        this.m_274367_(0.6f);
        this.f_21364_ = 1;
        this.m_21557_(false);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new EatBlockGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new FollowMobGoal((Mob)this, 1.0, 10.0f, 5.0f));
        this.f_21345_.m_25352_(7, (Goal)new AvoidEntityGoal((PathfinderMob)this, Monster.class, 3.0f, 1.0, 1.2));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SCARED_TICK, (Object)0);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("ScaredTick", this.getScaredTick());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setScaredTick(tag.m_128451_("ScaredTick"));
    }

    public int getScaredTick() {
        return (Integer)this.f_19804_.m_135370_(SCARED_TICK);
    }

    public void setScaredTick(int ticks) {
        this.f_19804_.m_135381_(SCARED_TICK, (Object)ticks);
    }

    public boolean isShaking() {
        return this.getScaredTick() > 0;
    }

    private void checkForThreats() {
        if (this.getScaredTick() > 0) {
            return;
        }
        List nearbyEntities = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_(3.0));
        for (LivingEntity entity : nearbyEntities) {
            Player player;
            if (!(entity instanceof Monster) && (!(entity instanceof Player) || !(player = (Player)entity).m_20142_())) continue;
            this.setScaredTick(80);
            this.m_20334_(this.m_20184_().f_82479_, 0.3, this.m_20184_().f_82481_);
            return;
        }
    }

    public void m_8107_() {
        super.m_8107_();
        this.checkForThreats();
        if (this.getScaredTick() > 0) {
            this.setScaredTick(this.getScaredTick() - 1);
        }
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.getScaredTick() > 0) {
            travelVector = Vec3.f_82478_;
        }
        super.m_7023_(travelVector);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.getScaredTick() > 0) {
            amount = Math.max(0.0f, (amount - 1.0f) / 2.0f);
        }
        this.setScaredTick(80);
        this.m_20334_(this.m_20184_().f_82479_, 0.4, this.m_20184_().f_82481_);
        return super.m_6469_(source, amount);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (item == Items.f_42574_) {
            if (!this.m_9236_().f_46443_) {
                itemstack.m_41622_(16, (LivingEntity)player, p -> p.m_21190_(hand));
                this.m_20000_((ItemLike)RedevModItems.ARMADILLO_SCUTE.get(), 1);
                this.m_5496_(SoundEvents.f_12344_, 1.0f, 1.0f);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    public void m_146762_(int age) {
        if (this.m_6162_() && age >= 0 && !this.m_9236_().f_46443_) {
            this.m_19998_((ItemLike)RedevModItems.ARMADILLO_SCUTE.get());
            BlockPos pos = this.m_20183_();
            BlockState blockState = this.m_9236_().m_8055_(pos.m_7495_());
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), this.m_20185_(), this.m_20186_(), this.m_20189_(), 10, 0.2, 0.2, 0.2, 0.1);
        }
        super.m_146762_(age);
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.fox.sleep"));
    }

    public void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.pig.step")), 0.15f, 1.0f);
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.rabbit.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.rabbit.death"));
    }

    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageable) {
        ArmadilloEntity retval = (ArmadilloEntity)((EntityType)RedevModEntities.ARMADILLO.get()).m_20615_((Level)serverWorld);
        retval.m_6518_((ServerLevelAccessor)serverWorld, serverWorld.m_6436_(retval.m_20183_()), MobSpawnType.BREEDING, null, null);
        return retval;
    }

    public boolean m_6898_(ItemStack stack) {
        return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42591_)}).test(stack);
    }

    public boolean m_7337_(Entity entity) {
        return true;
    }

    public boolean m_5829_() {
        return true;
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)RedevModEntities.ARMADILLO.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_184228_) && world.m_45524_(pos, 0) > 8);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.2);
        builder = builder.m_22268_(Attributes.f_22276_, 12.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        builder = builder.m_22268_(Attributes.f_22278_, 0.4);
        return builder;
    }
}

