/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.entity;

import net.mcreator.redev.init.RedevModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class BrilliantBeetleEntity
extends TamableAnimal {
    private int rideTicks = 0;

    public BrilliantBeetleEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<BrilliantBeetleEntity>)((EntityType)RedevModEntities.BRILLIANT_BEETLE.get()), world);
    }

    public BrilliantBeetleEntity(EntityType<BrilliantBeetleEntity> type, Level world) {
        super(type, world);
        this.m_274367_(1.1f);
        this.f_21364_ = 3;
        this.m_21557_(false);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            protected double m_6639_(LivingEntity entity) {
                return this.f_25540_.m_20205_() * this.f_25540_.m_20205_() + entity.m_20205_();
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 0.8));
        this.f_21345_.m_25352_(5, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(6, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(7, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new FloatGoal((Mob)this));
        this.f_21346_.m_25352_(10, (Goal)new NearestAttackableTargetGoal((Mob)this, Spider.class, false, false));
        this.f_21345_.m_25352_(11, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42591_}), false));
    }

    public boolean m_7757_(LivingEntity target, LivingEntity owner) {
        if (target instanceof TamableAnimal) {
            TamableAnimal tamed = (TamableAnimal)target;
            return !tamed.m_21824_() || tamed.m_269323_() != owner;
        }
        if (target instanceof Player && owner instanceof Player) {
            return ((Player)owner).m_7099_((Player)target);
        }
        return true;
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.spider.ambient"));
    }

    public void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.spider.step")), 0.15f, 1.0f);
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.spider.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.spider.death"));
    }

    public boolean m_6469_(DamageSource damagesource, float amount) {
        if (damagesource.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        return super.m_6469_(damagesource, amount);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        Item item = itemStack.m_41720_();
        if (!this.m_21824_() && this.m_6898_(itemStack)) {
            if (!this.m_9236_().f_46443_) {
                this.m_142075_(player, hand, itemStack);
                if (this.f_19796_.m_188503_(3) == 0) {
                    this.m_21828_(player);
                    this.m_9236_().m_7605_((Entity)this, (byte)7);
                } else {
                    this.m_9236_().m_7605_((Entity)this, (byte)6);
                }
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (this.m_21824_() && this.m_6898_(itemStack) && this.m_21223_() < this.m_21233_() && this.m_21830_((LivingEntity)player)) {
            this.m_142075_(player, hand, itemStack);
            this.m_5634_(4.0f);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (this.m_21824_() && this.m_6898_(itemStack) && this.m_5957_()) {
            this.m_142075_(player, hand, itemStack);
            this.m_27595_(player);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (!this.m_9236_().f_46443_) {
            player.m_20329_((Entity)this);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageable) {
        BrilliantBeetleEntity retval = (BrilliantBeetleEntity)((EntityType)RedevModEntities.BRILLIANT_BEETLE.get()).m_20615_((Level)serverWorld);
        retval.m_6518_((ServerLevelAccessor)serverWorld, serverWorld.m_6436_(retval.m_20183_()), MobSpawnType.BREEDING, null, null);
        return retval;
    }

    public boolean m_6898_(ItemStack stack) {
        return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42591_)}).test(stack);
    }

    public void m_7023_(Vec3 dir) {
        Entity entity;
        if (this.m_20160_() && (entity = this.m_146895_()) instanceof Player) {
            Player player = (Player)entity;
            if (this.m_21824_()) {
                this.m_146922_(player.m_146908_());
                this.m_146926_(player.m_146909_() * 0.5f);
                this.m_19915_(this.m_146908_(), this.m_146909_());
                this.f_20883_ = player.m_146908_();
                this.f_20885_ = player.m_146908_();
                float forward = player.f_20902_;
                float strafe = 0.0f;
                double d1 = this.m_20185_() - this.f_19854_;
                double d0 = this.m_20189_() - this.f_19856_;
                float f1 = (float)Math.sqrt(d1 * d1 + d0 * d0) * 4.0f;
                if (f1 > 1.0f) {
                    f1 = 1.0f;
                }
                this.f_267362_.m_267771_(this.f_267362_.m_267731_() + (f1 - this.f_267362_.m_267731_()) * 0.4f);
                this.f_267362_.m_267590_(this.f_267362_.m_267756_() + this.f_267362_.m_267731_());
                this.m_267651_(true);
                super.m_7023_(new Vec3((double)strafe, 0.0, (double)forward));
            } else {
                super.m_7023_(dir);
            }
            return;
        }
        super.m_7023_(dir);
    }

    public void m_8119_() {
        super.m_8119_();
        CompoundTag persistentData = this.getPersistentData();
        if (!this.m_21824_() && this.m_20160_()) {
            Entity rider;
            ++this.rideTicks;
            if (this.rideTicks >= 100 && (rider = this.m_146895_()) instanceof Player) {
                Player player = (Player)rider;
                player.m_8127_();
                this.m_9236_().m_7605_((Entity)this, (byte)6);
                this.rideTicks = 0;
            }
        } else {
            this.rideTicks = 0;
        }
        if (this.m_20096_() || this.m_20069_() || !this.m_20160_()) {
            persistentData.m_128379_("isGliding", false);
        }
        if (!persistentData.m_128471_("isGliding")) {
            if (!this.m_20096_() && this.m_20184_().f_82480_ < 0.0) {
                Vec3 currentMovement = this.m_20184_();
                Vec3 floatMovement = this.m_20184_().m_82490_(0.5);
                this.m_20334_(currentMovement.f_82479_, floatMovement.f_82480_, currentMovement.f_82481_);
            }
        } else {
            Vec3 lookAngle = this.m_20154_();
            this.m_20334_(lookAngle.f_82479_, -0.025, lookAngle.f_82481_);
        }
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)RedevModEntities.BRILLIANT_BEETLE.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_184228_) && world.m_45524_(pos, 0) > 8);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.225);
        builder = builder.m_22268_(Attributes.f_22276_, 20.0);
        builder = builder.m_22268_(Attributes.f_22284_, 5.0);
        builder = builder.m_22268_(Attributes.f_22281_, 4.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        builder = builder.m_22268_(Attributes.f_22278_, 0.2);
        return builder;
    }
}

