/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.entity;

import net.mcreator.redev.init.RedevModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class FearlessFrogEntity
extends TamableAnimal {
    private int rideTicks = 0;
    private boolean canDoubleJump = true;

    public FearlessFrogEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<FearlessFrogEntity>)((EntityType)RedevModEntities.FEARLESS_FROG.get()), world);
    }

    public FearlessFrogEntity(EntityType<FearlessFrogEntity> type, Level world) {
        super(type, world);
        this.m_274367_(1.8f);
        this.f_21364_ = 3;
        this.m_21557_(false);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new PanicGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 0.8));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42591_}), false));
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.frog.ambient"));
    }

    public void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.frog.step")), 0.15f, 1.0f);
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.frog.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.frog.death"));
    }

    public boolean m_6469_(DamageSource damagesource, float amount) {
        if (damagesource.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        return super.m_6469_(damagesource, amount);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        Item item = itemStack.m_41720_();
        if (!this.m_21824_() && this.m_6898_(itemStack)) {
            if (!this.m_9236_().f_46443_) {
                this.m_142075_(player, hand, itemStack);
                if (this.f_19796_.m_188503_(3) == 0) {
                    this.m_21828_(player);
                    this.m_9236_().m_7605_((Entity)this, (byte)7);
                } else {
                    this.m_9236_().m_7605_((Entity)this, (byte)6);
                }
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (this.m_21824_() && this.m_6898_(itemStack) && this.m_21223_() < this.m_21233_() && this.m_21830_((LivingEntity)player)) {
            this.m_142075_(player, hand, itemStack);
            this.m_5634_(4.0f);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (this.m_21824_() && this.m_6898_(itemStack) && this.m_5957_()) {
            this.m_142075_(player, hand, itemStack);
            this.m_27595_(player);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (!this.m_9236_().f_46443_) {
            player.m_20329_((Entity)this);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    public void m_8119_() {
        super.m_8119_();
        CompoundTag persistentData = this.getPersistentData();
        if (!this.m_21824_() && this.m_20160_()) {
            Entity rider;
            ++this.rideTicks;
            if (this.rideTicks >= 100 && (rider = this.m_146895_()) instanceof Player) {
                Player player = (Player)rider;
                player.m_8127_();
                this.m_9236_().m_7605_((Entity)this, (byte)6);
                this.rideTicks = 0;
            }
        } else {
            this.rideTicks = 0;
        }
        if (this.m_20096_()) {
            persistentData.m_128347_("frogJumps", 2.0);
        }
    }

    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageable) {
        FearlessFrogEntity retval = (FearlessFrogEntity)((EntityType)RedevModEntities.FEARLESS_FROG.get()).m_20615_((Level)serverWorld);
        retval.m_6518_((ServerLevelAccessor)serverWorld, serverWorld.m_6436_(retval.m_20183_()), MobSpawnType.BREEDING, null, null);
        return retval;
    }

    public boolean m_6898_(ItemStack stack) {
        return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42591_)}).test(stack);
    }

    public boolean m_6063_() {
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        Level world = this.m_9236_();
        FearlessFrogEntity entity = this;
        return false;
    }

    public void m_7023_(Vec3 travelVector) {
        LivingEntity livingEntity;
        if (this.m_20160_() && (livingEntity = this.m_6688_()) instanceof Player) {
            Player player = (Player)livingEntity;
            this.m_146922_(player.m_146908_());
            this.m_146926_(player.m_146909_() * 0.5f);
            this.m_19915_(this.m_146908_(), this.m_146909_());
            this.f_20883_ = this.m_146908_();
            this.f_20885_ = this.m_146908_();
            float forward = player.f_20902_;
            float strafe = player.f_20900_;
            if (forward != 0.0f || strafe != 0.0f) {
                this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
                super.m_7023_(new Vec3((double)strafe, travelVector.f_82480_, (double)forward));
            } else {
                super.m_7023_(Vec3.f_82478_);
            }
        } else {
            super.m_7023_(travelVector);
        }
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)RedevModEntities.FEARLESS_FROG.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_184228_) && world.m_45524_(pos, 0) > 8);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.25);
        builder = builder.m_22268_(Attributes.f_22276_, 20.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 3.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        return builder;
    }
}

