/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.entity;

import java.util.Random;
import net.mcreator.redev.entity.MagicOrbEntity;
import net.mcreator.redev.init.RedevModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class NecromancerEntity
extends SpellcasterIllager
implements RangedAttackMob {
    private static final EntityDataAccessor<Integer> SPELL_COOLDOWN = SynchedEntityData.m_135353_(NecromancerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final int CAST_DURATION = 30;

    public NecromancerEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<NecromancerEntity>)((EntityType)RedevModEntities.NECROMANCER.get()), world);
    }

    public NecromancerEntity(EntityType<NecromancerEntity> type, Level world) {
        super(type, world);
        this.m_274367_(0.6f);
        this.f_21364_ = 10;
        this.m_21557_(false);
        this.m_6210_();
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new NecromancerSummonSpell());
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 0.8, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21345_.m_25352_(1, (Goal)new RangedAttackGoal(this, 1.25, 30, 10.0f){

            public boolean m_8045_() {
                return this.m_8036_();
            }
        });
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SPELL_COOLDOWN, (Object)this.getRandomCooldown());
    }

    public void m_6075_() {
        super.m_6075_();
        int cooldown = (Integer)this.f_19804_.m_135370_(SPELL_COOLDOWN);
        if (cooldown > 0) {
            this.f_19804_.m_135381_(SPELL_COOLDOWN, (Object)(cooldown - 1));
        }
    }

    public boolean isSpellReady() {
        return (Integer)this.f_19804_.m_135370_(SPELL_COOLDOWN) <= 0;
    }

    private void resetSpellCooldown() {
        this.f_19804_.m_135381_(SPELL_COOLDOWN, (Object)this.getRandomCooldown());
    }

    private int getRandomCooldown() {
        return this.f_19796_.m_188503_(41) + 160;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("redev:necromancer.idle"));
    }

    public void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("redev:necromancer.step")), 0.15f, 1.0f);
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("redev:necromancer.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("redev:necromancer.death"));
    }

    public SoundEvent m_7930_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.evoker.celebrate"));
    }

    public SoundEvent m_7894_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.evoker.cast_spell"));
    }

    public void m_6504_(LivingEntity target, float flval) {
        MagicOrbEntity.shoot((LivingEntity)this, target);
    }

    public EntityDimensions m_6972_(Pose pose) {
        return super.m_6972_(pose).m_20388_(1.3f);
    }

    public boolean m_7490_() {
        return false;
    }

    public void m_7895_(int wave, boolean unused) {
    }

    public boolean m_37882_() {
        return false;
    }

    public static void init() {
        Raid.RaiderType.create((String)"necromancer", (EntityType)((EntityType)RedevModEntities.NECROMANCER.get()), (int[])new int[]{0, 0, 0, 0, 0, 0, 0, 0});
        SpawnPlacements.m_21754_((EntityType)((EntityType)RedevModEntities.NECROMANCER.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.m_46791_() != Difficulty.PEACEFUL && Monster.m_219009_((ServerLevelAccessor)world, (BlockPos)pos, (RandomSource)random) && Mob.m_217057_((EntityType)entityType, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random));
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 30.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 4.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        return builder;
    }

    private class NecromancerSummonSpell
    extends Goal {
        private int castingTicks;
        private boolean isCasting;

        private NecromancerSummonSpell() {
        }

        public boolean m_8036_() {
            return NecromancerEntity.this.isSpellReady() && NecromancerEntity.this.m_5448_() != null;
        }

        public void m_8056_() {
            this.castingTicks = 30;
            this.isCasting = true;
            NecromancerEntity.this.m_33727_(SpellcasterIllager.IllagerSpell.SUMMON_VEX);
            NecromancerEntity.this.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.evoker.prepare_summon")), 1.0f, 1.0f);
        }

        public void m_8037_() {
            --this.castingTicks;
            if (this.castingTicks == 0) {
                this.summonMinions();
                this.m_8041_();
            }
        }

        public boolean m_8045_() {
            return this.castingTicks > 0;
        }

        public void m_8041_() {
            this.isCasting = false;
            NecromancerEntity.this.m_33727_(SpellcasterIllager.IllagerSpell.NONE);
            NecromancerEntity.this.resetSpellCooldown();
            NecromancerEntity.this.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.evoker.cast_spell")), 1.0f, 1.0f);
        }

        private void summonMinions() {
            if (NecromancerEntity.this.m_5448_() == null) {
                return;
            }
            Level world = NecromancerEntity.this.m_9236_();
            BlockPos necromancerPos = NecromancerEntity.this.m_20183_();
            Random random = new Random();
            int minionsToSpawn = random.nextInt(2) + 3;
            for (int i = 0; i < minionsToSpawn; ++i) {
                BlockPos spawnPos = necromancerPos.m_7918_(random.nextInt(7) - 3, 0, random.nextInt(7) - 3);
                Object minion = random.nextFloat() < 0.3f ? new Skeleton(EntityType.f_20524_, world) : new Zombie(EntityType.f_20501_, world);
                minion.m_7678_((double)spawnPos.m_123341_(), (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_(), random.nextFloat() * 360.0f, 0.0f);
                if (minion instanceof Mob) {
                    Mob mob = (Mob)minion;
                    mob.m_6710_(NecromancerEntity.this.m_5448_());
                }
                minion.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 160, 0, false, false));
                ((ServerLevelAccessor)world).m_47205_((Entity)minion);
                double minX = minion.m_20191_().f_82288_;
                double minY = minion.m_20191_().f_82289_;
                double minZ = minion.m_20191_().f_82290_;
                double maxX = minion.m_20191_().f_82291_;
                double maxY = minion.m_20191_().f_82292_;
                double maxZ = minion.m_20191_().f_82293_;
                for (int j = 0; j < 10; ++j) {
                    double particleX = minX + random.nextDouble() * (maxX - minX);
                    double particleY = minY + random.nextDouble() * (maxY - minY);
                    double particleZ = minZ + random.nextDouble() * (maxZ - minZ);
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123759_, particleX, particleY, particleZ, 0.0, 0.0, 0.0);
                }
            }
        }
    }
}

