/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.entity;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.mcreator.redev.init.RedevModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class WildfireEntity
extends Monster {
    private float allowedHeightOffset = 0.5f;
    private int nextHeightOffsetChangeTick;
    private int slamCooldown = 100;
    private boolean isNaturalSpawn = false;
    private int shockwaveChargeTimer = 0;
    private static final EntityDataAccessor<Boolean> DATA_CHARGED = SynchedEntityData.m_135353_(WildfireEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_SHOCKWAVE = SynchedEntityData.m_135353_(WildfireEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_INVULNERABLE = SynchedEntityData.m_135353_(WildfireEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int invulnerabilityTimer = 0;

    public WildfireEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<WildfireEntity>)((EntityType)RedevModEntities.WILDFIRE.get()), world);
    }

    public WildfireEntity(EntityType<WildfireEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 10;
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.LAVA, 8.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
        this.f_21342_ = new WildfireMoveControl(this);
        this.m_6210_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_CHARGED, (Object)false);
        this.f_19804_.m_135372_(DATA_SHOCKWAVE, (Object)false);
        this.f_19804_.m_135372_(DATA_INVULNERABLE, (Object)false);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.isNaturalSpawn = compound.m_128471_("IsNaturalSpawn");
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return !this.isNaturalSpawn;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag dataTag) {
        SpawnGroupData spawnData = super.m_6518_(world, difficulty, spawnType, groupData, dataTag);
        if (spawnType == MobSpawnType.NATURAL) {
            this.isNaturalSpawn = true;
            int blazeCount = 3 + this.f_19796_.m_188503_(2);
            for (int i = 0; i < blazeCount; ++i) {
                Blaze blaze = (Blaze)EntityType.f_20551_.m_20615_((Level)world.m_6018_());
                if (blaze == null) continue;
                double offsetX = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 6.0;
                double offsetZ = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 6.0;
                blaze.m_7678_(offsetX, this.m_20186_(), offsetZ, this.f_19796_.m_188501_() * 360.0f, 0.0f);
                blaze.m_6518_(world, difficulty, spawnType, null, null);
                blaze.m_21530_();
                world.m_7967_((Entity)blaze);
            }
        }
        return spawnData;
    }

    public boolean isCharged() {
        return (Boolean)this.f_19804_.m_135370_(DATA_CHARGED);
    }

    public void setCharged(boolean charged) {
        this.f_19804_.m_135381_(DATA_CHARGED, (Object)charged);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected PathNavigation m_6037_(Level world) {
        return new GroundPathNavigation((Mob)this, world);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(4, (Goal)new WildfireAttackGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    private void performSlamAttack(LivingEntity target) {
        if (this.m_21223_() < this.m_21233_() / 5.0f) {
            return;
        }
        if (!this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -1.0, 0.0));
            this.f_19812_ = true;
            return;
        }
        this.setShockwaveChargeDown(true);
        this.shockwaveChargeTimer = 60;
        this.m_9236_().m_255391_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), 2.0f, false, Level.ExplosionInteraction.NONE);
        double horizontalKnockbackStrength = 1.6;
        double verticalKnockbackStrength = 0.3;
        double dx = target.m_20185_() - this.m_20185_();
        double dz = target.m_20189_() - this.m_20189_();
        double distance = Math.sqrt(dx * dx + dz * dz);
        if (distance > 0.0) {
            target.m_20256_(target.m_20184_().m_82520_(dx / distance * horizontalKnockbackStrength, verticalKnockbackStrength, dz / distance * horizontalKnockbackStrength));
        }
        target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 2, false, true));
        this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11913_, this.m_5720_(), 1.0f, 0.9f + this.f_19796_.m_188501_() * 0.2f);
        this.slamCooldown = 100;
        if (this.f_19796_.m_188501_() < 0.4f) {
            this.invulnerabilityTimer = 20 * (3 + this.f_19796_.m_188503_(2));
            this.setInvulnerableState(true);
        }
    }

    protected void m_8024_() {
        LivingEntity target;
        if (this.isShockwaveChargeDown() && this.shockwaveChargeTimer > 0) {
            --this.shockwaveChargeTimer;
            if (this.shockwaveChargeTimer <= 0) {
                this.setShockwaveChargeDown(false);
            }
        }
        if (this.invulnerabilityTimer > 0) {
            --this.invulnerabilityTimer;
            if (!this.m_20096_()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.5, 0.0));
                this.f_19812_ = true;
            }
            if (this.invulnerabilityTimer <= 0) {
                this.setInvulnerableState(false);
                this.slamCooldown = 0;
            }
        }
        if (this.slamCooldown > 0) {
            --this.slamCooldown;
        }
        --this.nextHeightOffsetChangeTick;
        if (this.nextHeightOffsetChangeTick <= 0) {
            this.nextHeightOffsetChangeTick = 100;
            this.allowedHeightOffset = (float)this.f_19796_.m_216328_(0.5, 6.891);
        }
        if ((target = this.m_5448_()) != null && target.m_20188_() > this.m_20188_() + (double)this.allowedHeightOffset && this.m_6779_(target)) {
            Vec3 motion = this.m_20184_();
            this.m_20256_(motion.m_82520_(0.0, ((double)0.3f - motion.f_82480_) * (double)0.3f, 0.0));
            this.f_19812_ = true;
        } else if (this.m_20096_() && this.f_19796_.m_188501_() < 0.02f) {
            double walkX = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 8.0;
            double walkZ = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 8.0;
            this.m_21573_().m_26519_(walkX, this.m_20186_(), walkZ, 1.0);
        }
        if (!this.m_20096_() && this.m_20184_().f_82480_ < 0.0) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
        }
        super.m_8024_();
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("redev:wildfire.ambient"));
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("redev:wildfire.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("redev:wildfire.death"));
    }

    public boolean m_142535_(float l, float d, DamageSource source) {
        return false;
    }

    public boolean m_6469_(DamageSource damagesource, float amount) {
        if (this.m_21223_() >= this.m_21233_() / 5.0f) {
            if (damagesource.m_7640_() instanceof AbstractArrow) {
                return false;
            }
            if (damagesource.m_276093_(DamageTypes.f_268565_) || damagesource.m_276093_(DamageTypes.f_268448_)) {
                return false;
            }
            if (damagesource.m_276093_(DamageTypes.f_268714_)) {
                return false;
            }
            if (damagesource.m_276093_(DamageTypes.f_268526_)) {
                return false;
            }
        }
        if (damagesource.m_276093_(DamageTypes.f_268631_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        if (this.isInvulnerableState()) {
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12346_, this.m_5720_(), 1.0f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
            return false;
        }
        return super.m_6469_(damagesource, amount);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_20096_() && this.m_20184_().f_82480_ < 0.0) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
        }
        if (this.m_9236_().f_46443_) {
            for (int i = 0; i < 2; ++i) {
                if (this.isCharged()) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20208_(0.3), this.m_20187_(), this.m_20262_(0.3), 0.0, 0.0, 0.0);
                    continue;
                }
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20208_(0.3), this.m_20187_(), this.m_20262_(0.3), 0.0, 0.0, 0.0);
            }
        }
    }

    public boolean m_6128_() {
        return true;
    }

    public EntityDimensions m_6972_(Pose pose) {
        return super.m_6972_(pose).m_20388_(1.3f);
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void m_20242_(boolean ignored) {
        super.m_20242_(true);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("IsNaturalSpawn", this.isNaturalSpawn);
    }

    public boolean isShockwaveChargeDown() {
        return (Boolean)this.f_19804_.m_135370_(DATA_SHOCKWAVE);
    }

    public void setShockwaveChargeDown(boolean value) {
        this.f_19804_.m_135381_(DATA_SHOCKWAVE, (Object)value);
    }

    public boolean isInvulnerableState() {
        return (Boolean)this.f_19804_.m_135370_(DATA_INVULNERABLE);
    }

    public void setInvulnerableState(boolean state) {
        this.f_19804_.m_135381_(DATA_INVULNERABLE, (Object)state);
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)RedevModEntities.WILDFIRE.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.m_46791_() != Difficulty.PEACEFUL && Monster.m_219009_((ServerLevelAccessor)world, (BlockPos)pos, (RandomSource)random) && Mob.m_217057_((EntityType)entityType, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random));
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.275);
        builder = builder.m_22268_(Attributes.f_22276_, 80.0);
        builder = builder.m_22268_(Attributes.f_22284_, 5.0);
        builder = builder.m_22268_(Attributes.f_22281_, 7.0);
        builder = builder.m_22268_(Attributes.f_22277_, 48.0);
        builder = builder.m_22268_(Attributes.f_22278_, 0.5);
        builder = builder.m_22268_(Attributes.f_22280_, 0.275);
        return builder;
    }

    static class WildfireMoveControl
    extends MoveControl {
        private final WildfireEntity wildfire;
        private int floatCooldown;

        public WildfireMoveControl(WildfireEntity wildfire) {
            super((Mob)wildfire);
            this.wildfire = wildfire;
        }
    }

    static class WildfireAttackGoal
    extends Goal {
        private final WildfireEntity wildfire;
        private int attackStep;
        private int attackTime;

        public WildfireAttackGoal(WildfireEntity wildfire) {
            this.wildfire = wildfire;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity target = this.wildfire.m_5448_();
            return target != null && target.m_6084_() && this.wildfire.m_6779_(target) && !this.wildfire.m_20147_();
        }

        public void m_8056_() {
            this.attackStep = 0;
            this.wildfire.setCharged(true);
        }

        public void m_8041_() {
            this.attackStep = 0;
            this.wildfire.setCharged(false);
        }

        public void m_8037_() {
            --this.attackTime;
            LivingEntity target = this.wildfire.m_5448_();
            if (target != null) {
                double distanceSq = this.wildfire.m_20280_((Entity)target);
                if (distanceSq < 9.0) {
                    if (this.wildfire.slamCooldown > 0) {
                        return;
                    }
                    this.wildfire.performSlamAttack(target);
                } else if (distanceSq < 64.0) {
                    if (this.attackTime <= 0) {
                        ++this.attackStep;
                        if (this.attackStep <= 3) {
                            this.fireAtTarget(target);
                            this.wildfire.setCharged(true);
                            this.attackTime = 10;
                        } else {
                            this.attackStep = 0;
                            this.attackTime = 80;
                            this.wildfire.setCharged(false);
                        }
                    }
                    this.wildfire.m_21563_().m_24960_((Entity)target, 10.0f, 10.0f);
                }
            }
        }

        private void fireAtTarget(LivingEntity target) {
            double dx = target.m_20185_() - this.wildfire.m_20185_();
            double dy = target.m_20227_(0.5) - this.wildfire.m_20227_(0.5);
            double dz = target.m_20189_() - this.wildfire.m_20189_();
            LargeFireball fireball = new LargeFireball(this.wildfire.m_9236_(), (LivingEntity)this.wildfire, dx, dy, dz, 1);
            fireball.m_6034_(this.wildfire.m_20185_(), this.wildfire.m_20227_(0.5) + 0.5, this.wildfire.m_20189_());
            this.wildfire.m_9236_().m_7967_((Entity)fireball);
            this.wildfire.m_9236_().m_5594_(null, this.wildfire.m_20183_(), SoundEvents.f_11705_, this.wildfire.m_5720_(), 1.0f, 1.0f + (this.wildfire.f_19796_.m_188501_() - this.wildfire.f_19796_.m_188501_()) * 0.2f);
        }
    }
}

