/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.item;

import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BannerOfCourageItem
extends Item {
    private static final String NBT_MODE = "mode";
    private static final String NBT_BOUND_UUID = "bound_uuid";

    public BannerOfCourageItem() {
        super(new Item.Properties().m_41503_(16).m_41497_(Rarity.UNCOMMON));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private Predicate<Mob> getValidMobPredicate(Player player) {
        return mob -> {
            TamableAnimal tamable;
            return mob instanceof TamableAnimal && (tamable = (TamableAnimal)mob).m_21830_((LivingEntity)player) || mob instanceof NeutralMob || mob.m_7307_((Entity)player) || mob.m_6095_().m_204039_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("redev", "enlistable_entities")));
        };
    }

    public UseAnim m_6164_(ItemStack itemstack) {
        return UseAnim.NONE;
    }

    public int m_8105_(ItemStack itemstack) {
        return 1;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (!(level instanceof ServerLevel)) {
            return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ItemStack stack = player.m_21120_(hand);
        Mode mode = Mode.valueOf(stack.m_41784_().m_128461_(NBT_MODE).isEmpty() ? "ALL" : stack.m_41784_().m_128461_(NBT_MODE));
        List followers = serverLevel.m_6443_(Mob.class, player.m_20191_().m_82400_(8.0), this.getValidMobPredicate(player));
        switch (mode) {
            case ALL: {
                for (Mob mob : followers) {
                    mob.m_21573_().m_5624_((Entity)player, 1.2);
                }
                break;
            }
            case RANDOM: {
                if (followers.isEmpty()) break;
                Mob chosen = (Mob)followers.get(serverLevel.f_46441_.m_188503_(followers.size()));
                chosen.m_21573_().m_5624_((Entity)player, 1.2);
                break;
            }
            case BIND: {
                LivingEntity le;
                LivingEntity bound;
                CompoundTag tag = stack.m_41783_();
                if (tag == null || !tag.m_128441_(NBT_BOUND_UUID)) break;
                UUID uuid = tag.m_128342_(NBT_BOUND_UUID);
                Entity entity = serverLevel.m_8791_(uuid);
                LivingEntity livingEntity = bound = entity instanceof LivingEntity ? (le = (LivingEntity)entity) : null;
                if (!(bound instanceof Mob)) break;
                Mob mob = (Mob)bound;
                if (!this.getValidMobPredicate(player).test(mob)) break;
                mob.m_21573_().m_5624_((Entity)player, 1.2);
            }
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        Level level = context.m_43725_();
        ItemStack stack = context.m_43722_();
        if (player != null && player.m_6144_() && !level.f_46443_) {
            CompoundTag tag = stack.m_41784_();
            Mode current = Mode.valueOf(tag.m_128461_(NBT_MODE).isEmpty() ? "ALL" : tag.m_128461_(NBT_MODE));
            Mode next = current.next();
            tag.m_128359_(NBT_MODE, next.name());
            player.m_5661_((Component)Component.m_237113_((String)("Banner mode: " + next.name())), true);
            player.m_21011_(context.m_43724_(), true);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private void spawnTargetParticles(ServerLevel level, LivingEntity entity) {
        int particleCount = level.m_213780_().m_216339_(8, 12);
        for (int i = 0; i < particleCount; ++i) {
            double xOffset = (level.m_213780_().m_188500_() - 0.5) * (double)entity.m_20205_() * 1.25;
            double yOffset = level.m_213780_().m_188500_() * (double)entity.m_20206_();
            double zOffset = (level.m_213780_().m_188500_() - 0.5) * (double)entity.m_20205_() * 1.25;
            level.m_8767_((ParticleOptions)ParticleTypes.f_175830_, entity.m_20185_() + xOffset, entity.m_20186_() + yOffset, entity.m_20189_() + zOffset, 1, 0.0, 0.0, 0.0, 0.05);
        }
    }

    @SubscribeEvent
    public void onEntityRightClick(PlayerInteractEvent.EntityInteract event) {
        ItemStack stack = event.getItemStack();
        if (!(stack.m_41720_() instanceof BannerOfCourageItem)) {
            return;
        }
        Player player = event.getEntity();
        Level level = player.m_9236_();
        Entity entity = event.getTarget();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = (LivingEntity)entity;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (player.m_6144_() && target instanceof Mob) {
            Mob mob2 = (Mob)target;
            if (this.getValidMobPredicate(player).test(mob2)) {
                this.spawnTargetParticles(serverLevel, (LivingEntity)mob2);
                stack.m_41784_().m_128362_(NBT_BOUND_UUID, mob2.m_20148_());
                player.m_5661_((Component)Component.m_237113_((String)("Bound to: " + mob2.m_7755_().getString())), true);
                event.setCanceled(true);
                player.m_21011_(event.getHand(), true);
                event.setCancellationResult(InteractionResult.SUCCESS);
                return;
            }
        }
        Mode mode = Mode.valueOf(stack.m_41784_().m_128461_(NBT_MODE).isEmpty() ? "ALL" : stack.m_41784_().m_128461_(NBT_MODE));
        List followers = serverLevel.m_6443_(Mob.class, player.m_20191_().m_82400_(8.0), this.getValidMobPredicate(player));
        switch (mode) {
            case ALL: {
                followers.forEach(mob -> mob.m_6710_(target));
                this.spawnTargetParticles(serverLevel, target);
                break;
            }
            case RANDOM: {
                if (followers.isEmpty()) break;
                Mob chosen = (Mob)followers.get(serverLevel.f_46441_.m_188503_(followers.size()));
                chosen.m_6710_(target);
                this.spawnTargetParticles(serverLevel, target);
                break;
            }
            case BIND: {
                LivingEntity le;
                LivingEntity bound;
                CompoundTag tag = stack.m_41783_();
                if (tag == null || !tag.m_128441_(NBT_BOUND_UUID)) break;
                UUID uuid = tag.m_128342_(NBT_BOUND_UUID);
                Entity entity2 = serverLevel.m_8791_(uuid);
                LivingEntity livingEntity = bound = entity2 instanceof LivingEntity ? (le = (LivingEntity)entity2) : null;
                if (!(bound instanceof Mob)) break;
                Mob mob3 = (Mob)bound;
                if (!this.getValidMobPredicate(player).test(mob3)) break;
                mob3.m_6710_(target);
                this.spawnTargetParticles(serverLevel, target);
            }
        }
        player.m_21011_(event.getHand(), true);
        stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(event.getHand()));
        event.setCanceled(true);
        event.setCancellationResult(InteractionResult.SUCCESS);
    }

    public static enum Mode {
        ALL,
        RANDOM,
        BIND;


        public Mode next() {
            return Mode.values()[(this.ordinal() + 1) % Mode.values().length];
        }
    }
}

