/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class FlaskItem
extends Item {
    private static final String TAG_ITEMS = "Items";
    private static final int MAX_ITEMS = 5;
    private static final int BAR_COLOR = Mth.m_14159_((float)0.83f, (float)0.2f, (float)0.81f);

    public FlaskItem() {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.COMMON));
    }

    private static boolean isValidItem(ItemStack stack) {
        return stack.m_41720_() instanceof PotionItem;
    }

    private static Stream<ItemStack> getContents(ItemStack flask) {
        CompoundTag tag = flask.m_41783_();
        if (tag == null || !tag.m_128441_(TAG_ITEMS)) {
            return Stream.empty();
        }
        ListTag items = tag.m_128437_(TAG_ITEMS, 10);
        return items.stream().map(CompoundTag.class::cast).map(ItemStack::m_41712_);
    }

    private static ListTag getItemList(ItemStack flask) {
        CompoundTag tag = flask.m_41784_();
        if (!tag.m_128441_(TAG_ITEMS)) {
            tag.m_128365_(TAG_ITEMS, (Tag)new ListTag());
        }
        return tag.m_128437_(TAG_ITEMS, 10);
    }

    private static int getItemCount(ItemStack flask) {
        return (int)FlaskItem.getContents(flask).count();
    }

    private static boolean addItem(ItemStack flask, ItemStack toAdd) {
        if (!FlaskItem.isValidItem(toAdd) || FlaskItem.getItemCount(flask) >= 5) {
            return false;
        }
        ListTag itemList = FlaskItem.getItemList(flask);
        ItemStack newStack = toAdd.m_255036_(1);
        CompoundTag tag = new CompoundTag();
        newStack.m_41739_(tag);
        itemList.add((Object)tag);
        return true;
    }

    private static Optional<ItemStack> removeLast(ItemStack flask) {
        ListTag list = FlaskItem.getItemList(flask);
        if (list.isEmpty()) {
            return Optional.empty();
        }
        CompoundTag lastTag = list.m_128728_(list.size() - 1);
        list.remove(list.size() - 1);
        if (list.isEmpty()) {
            flask.m_41749_(TAG_ITEMS);
        }
        return Optional.of(ItemStack.m_41712_((CompoundTag)lastTag));
    }

    private static void setItemList(ItemStack flask, List<ItemStack> stacks) {
        ListTag newList = new ListTag();
        for (ItemStack stack : stacks) {
            CompoundTag tag = new CompoundTag();
            stack.m_41739_(tag);
            newList.add((Object)tag);
        }
        flask.m_41784_().m_128365_(TAG_ITEMS, (Tag)newList);
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        NonNullList contents = NonNullList.m_122779_();
        FlaskItem.getContents(stack).forEach(arg_0 -> contents.add(arg_0));
        return Optional.of(new BundleTooltip(contents, FlaskItem.getItemCount(stack)));
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237113_((String)(FlaskItem.getItemCount(stack) + "/5")).m_130940_(ChatFormatting.GRAY));
    }

    public boolean m_142522_(ItemStack stack) {
        return FlaskItem.getItemCount(stack) > 0;
    }

    public int m_142158_(ItemStack stack) {
        return Math.min(1 + 12 * FlaskItem.getItemCount(stack) / 5, 13);
    }

    public int m_142159_(ItemStack stack) {
        return BAR_COLOR;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public int m_8105_(ItemStack stack) {
        return 32;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack flask = player.m_21120_(hand);
        ArrayList<ItemStack> potions = new ArrayList<ItemStack>(FlaskItem.getContents(flask).toList());
        if (player.m_6144_()) {
            if (!potions.isEmpty()) {
                for (ItemStack stack : potions) {
                    player.m_36176_(stack, true);
                }
                flask.m_41749_(TAG_ITEMS);
                this.playDropSound((Entity)player);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                return InteractionResultHolder.m_19092_((Object)flask, (boolean)level.f_46443_);
            }
            return InteractionResultHolder.m_19100_((Object)flask);
        }
        if (potions.isEmpty()) {
            return InteractionResultHolder.m_19100_((Object)flask);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)flask);
    }

    public ItemStack m_5922_(ItemStack flask, Level level, LivingEntity user) {
        Item remaining;
        if (!(user instanceof Player)) {
            return flask;
        }
        Player player = (Player)user;
        ArrayList<ItemStack> potions = new ArrayList<ItemStack>(FlaskItem.getContents(flask).toList());
        if (potions.isEmpty()) {
            return flask;
        }
        Random random = new Random();
        int index = random.nextInt(potions.size());
        ItemStack potion = (ItemStack)potions.get(index);
        if (!level.f_46443_) {
            for (MobEffectInstance effect : PotionUtils.m_43547_((ItemStack)potion)) {
                player.m_7292_(new MobEffectInstance(effect));
            }
            player.m_5496_(SoundEvents.f_11911_, 1.0f, 1.0f);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        }
        if ((remaining = potion.m_41720_().m_41469_()) != null && remaining != Items.f_41852_) {
            potions.set(index, new ItemStack((ItemLike)remaining));
        } else {
            potions.remove(index);
        }
        FlaskItem.setItemList(flask, potions);
        return flask;
    }

    public boolean m_142207_(ItemStack flask, Slot slot, ClickAction action, Player player) {
        if (flask.m_41613_() != 1 || action != ClickAction.SECONDARY) {
            return false;
        }
        ItemStack target = slot.m_7993_();
        if (target.m_41619_()) {
            FlaskItem.removeLast(flask).ifPresent(stack -> slot.m_150659_(stack));
            this.playRemoveSound((Entity)player);
        } else if (FlaskItem.isValidItem(target) && FlaskItem.addItem(flask, target)) {
            slot.m_6201_(1);
            this.playInsertSound((Entity)player);
        }
        return true;
    }

    public boolean m_142305_(ItemStack flask, ItemStack stack, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (flask.m_41613_() != 1 || action != ClickAction.SECONDARY || !slot.m_150651_(player)) {
            return false;
        }
        if (stack.m_41619_()) {
            FlaskItem.removeLast(flask).ifPresent(s -> {
                this.playRemoveSound((Entity)player);
                access.m_142104_(s);
            });
        } else if (FlaskItem.isValidItem(stack) && FlaskItem.addItem(flask, stack)) {
            stack.m_41774_(1);
            this.playInsertSound((Entity)player);
        }
        return true;
    }

    private void playInsertSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184215_, 0.8f, 1.0f);
    }

    private void playRemoveSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184216_, 0.8f, 1.0f);
    }

    private void playDropSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184214_, 0.8f, 1.0f);
    }

    public void m_142023_(ItemEntity itemEntity) {
        ItemUtils.m_150952_((ItemEntity)itemEntity, FlaskItem.getContents(itemEntity.m_32055_()));
    }
}

