/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.mixins;

import java.util.Optional;
import net.mcreator.redev.block.EnderCheckpointBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerRespawnMixin {
    @Inject(method={"findRespawnPositionAndUseSpawnBlock"}, at={@At(value="HEAD")}, cancellable=true)
    private static void injectRespawn(ServerLevel world, BlockPos pos, float angle, boolean forced, boolean alive, CallbackInfoReturnable<Optional<Vec3>> cir) {
        BlockState blockState = world.m_8055_(pos);
        Block block = blockState.m_60734_();
        if (block instanceof EnderCheckpointBlock && (Integer)blockState.m_61143_((Property)EnderCheckpointBlock.CHARGES) > 0) {
            ServerLevel checkpointLevel = world.m_7654_().m_129880_(world.m_46472_());
            if (!world.m_46472_().equals((Object)checkpointLevel.m_46472_())) {
                return;
            }
            Optional<Vec3> respawnPos = EnderCheckpointBlock.findSafeRespawnPosition(EntityType.f_20532_, (CollisionGetter)world, pos);
            if (!alive && respawnPos.isPresent()) {
                world.m_7731_(pos, (BlockState)blockState.m_61124_((Property)EnderCheckpointBlock.CHARGES, (Comparable)Integer.valueOf(0)), 3);
            }
            cir.setReturnValue(respawnPos);
        }
    }
}

