/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.block;

import net.mcreator.redev.init.RedevModBlocks;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.common.IForgeShearable;

public class BrambleBlock
extends BushBlock
implements IForgeShearable {
    protected static final float AABB_OFFSET = 6.0f;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);

    public BrambleBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60918_(SoundType.f_56740_).m_60966_().m_60910_().m_278166_(PushReaction.DESTROY).m_222979_(BlockBehaviour.OffsetType.XZ).m_60988_());
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity instanceof LivingEntity && !entity.m_6144_()) {
            entity.m_7601_(state, new Vec3(0.8, 0.75, 0.8));
            if (!(level.f_46443_ || entity.f_19790_ == entity.m_20185_() && entity.f_19792_ == entity.m_20189_())) {
                double dx = Math.abs(entity.m_20185_() - entity.f_19790_);
                double dz = Math.abs(entity.m_20189_() - entity.f_19792_);
                if ((dx >= 0.003 || dz >= 0.003) && level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    entity.m_6469_(serverLevel.m_269111_().m_269555_(), 1.0f);
                }
            }
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Vec3 offset = state.m_60824_(world, pos);
        return BrambleBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0).m_83216_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 100;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 60;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void blockColorLoad(RegisterColorHandlersEvent.Block event) {
        event.getBlockColors().m_92589_((bs, world, pos, index) -> world != null && pos != null ? BiomeColors.m_108793_((BlockAndTintGetter)world, (BlockPos)pos) : GrassColor.m_46415_((double)0.5, (double)1.0), new Block[]{(Block)RedevModBlocks.BRAMBLE.get()});
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void itemColorLoad(RegisterColorHandlersEvent.Item event) {
        event.getItemColors().m_92689_((stack, index) -> GrassColor.m_46415_((double)0.5, (double)1.0), new ItemLike[]{(ItemLike)RedevModBlocks.BRAMBLE.get()});
    }
}

