/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.enchantment;

import java.util.List;
import net.mcreator.redev.init.RedevModEnchantments;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class GravitalEnchantment
extends Enchantment {
    public GravitalEnchantment(EquipmentSlot ... slots) {
        super(Enchantment.Rarity.UNCOMMON, EnchantmentCategory.CROSSBOW, slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public int m_6586_() {
        return 3;
    }

    public boolean m_6591_() {
        return true;
    }

    protected boolean m_5975_(Enchantment ench) {
        return this != ench && !List.of(Enchantments.f_44962_, (Enchantment)RedevModEnchantments.FUSE_SHOT.get()).contains(ench);
    }

    @SubscribeEvent
    public void onProjectileImpact(ProjectileImpactEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof AbstractArrow)) {
            return;
        }
        AbstractArrow arrow = (AbstractArrow)entity;
        HitResult hitResult = event.getRayTraceResult();
        if (!(hitResult instanceof EntityHitResult)) {
            return;
        }
        EntityHitResult entityHitResult = (EntityHitResult)hitResult;
        Entity hitEntity = entityHitResult.m_82443_();
        if (!(hitEntity instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = (LivingEntity)hitEntity;
        Entity shooter = arrow.m_19749_();
        if (!(shooter instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)shooter;
        ItemStack crossbow = attacker.m_21205_();
        int level = EnchantmentHelper.m_44843_((Enchantment)this, (ItemStack)crossbow);
        if (level <= 0) {
            return;
        }
        this.applyChaindownEffect(target, level);
    }

    private void applyChaindownEffect(LivingEntity target, int levelEnchant) {
        float chance = 0.3f + 0.2f * (float)levelEnchant;
        if (target.m_217043_().m_188501_() > chance) {
            return;
        }
        int radius = 1 + levelEnchant * 2;
        AABB attractionBox = new AABB(target.m_20185_() - (double)radius, target.m_20186_() - (double)radius, target.m_20189_() - (double)radius, target.m_20185_() + (double)radius, target.m_20186_() + (double)radius, target.m_20189_() + (double)radius);
        int maxMobs = 3 + levelEnchant * 2;
        LivingEntity attackerEntity = target.m_21188_();
        LivingEntity attacker = attackerEntity instanceof LivingEntity ? attackerEntity : null;
        List nearbyMobs = target.m_9236_().m_6443_(LivingEntity.class, attractionBox, mob -> mob != target && mob != attacker);
        nearbyMobs.sort((mob1, mob2) -> Double.compare(mob1.m_20280_((Entity)target), mob2.m_20280_((Entity)target)));
        int mobsDragged = 0;
        for (LivingEntity mob3 : nearbyMobs) {
            double dz;
            double dy;
            if (mobsDragged >= maxMobs) break;
            double dx = target.m_20185_() - mob3.m_20185_();
            double distance = Math.sqrt(dx * dx + (dy = target.m_20186_() - mob3.m_20186_()) * dy + (dz = target.m_20189_() - mob3.m_20189_()) * dz);
            if (!(distance > 0.0)) continue;
            double strength = 0.3 + 0.2 * (double)levelEnchant;
            mob3.m_20256_(mob3.m_20184_().m_82520_(dx / distance * strength, dy / distance * strength, dz / distance * strength));
            ++mobsDragged;
        }
    }
}

