/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.enchantment;

import java.util.HashMap;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ParryEnchantment
extends Enchantment {
    private static final HashMap<UUID, Integer> COOLDOWN_TRACKER = new HashMap();

    public ParryEnchantment(EquipmentSlot ... slots) {
        super(Enchantment.Rarity.UNCOMMON, EnchantmentCategory.WEAPON, slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public boolean canApplyAtEnchantingTable(ItemStack itemstack) {
        return Ingredient.m_204132_((TagKey)ItemTags.create((ResourceLocation)new ResourceLocation("redev:rapiers"))).test(itemstack);
    }

    public boolean m_6591_() {
        return true;
    }

    public int m_6586_() {
        return 3;
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        ItemStack weapon = player.m_21205_();
        int level = weapon.getEnchantmentLevel((Enchantment)this);
        if (level <= 0) {
            return;
        }
        UUID playerUUID = player.m_20148_();
        if (player.m_6144_() && !this.isOnCooldown(playerUUID)) {
            event.setCanceled(true);
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12346_, SoundSource.PLAYERS, 1.0f, 2.0f);
            int cooldown = Math.max(0, 40 - level * 5);
            COOLDOWN_TRACKER.put(playerUUID, cooldown);
            player.m_36335_().m_41524_(weapon.m_41720_(), cooldown);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        UUID playerUUID = player.m_20148_();
        if (COOLDOWN_TRACKER.containsKey(playerUUID)) {
            int timeLeft = COOLDOWN_TRACKER.get(playerUUID) - 1;
            if (timeLeft <= 0) {
                COOLDOWN_TRACKER.remove(playerUUID);
            } else {
                COOLDOWN_TRACKER.put(playerUUID, timeLeft);
            }
        }
    }

    private boolean isOnCooldown(UUID playerUUID) {
        return COOLDOWN_TRACKER.getOrDefault(playerUUID, 0) > 0;
    }
}

