/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.enchantment;

import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class RicochetEnchantment
extends Enchantment {
    public RicochetEnchantment(EquipmentSlot ... slots) {
        super(Enchantment.Rarity.UNCOMMON, EnchantmentCategory.BOW, slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public int m_6586_() {
        return 3;
    }

    protected boolean m_5975_(Enchantment ench) {
        return this != ench && !List.of(Enchantments.f_44952_).contains(ench);
    }

    public boolean m_6591_() {
        return true;
    }

    @SubscribeEvent
    public void onMobHit(LivingHurtEvent event) {
        AbstractArrow arrow;
        Entity entity;
        Entity source = event.getSource().m_7640_();
        if (!(source instanceof AbstractArrow) || !((entity = (arrow = (AbstractArrow)source).m_19749_()) instanceof Player)) {
            return;
        }
        Player user = (Player)entity;
        ItemStack bow = user.m_21205_();
        int level = bow.getEnchantmentLevel((Enchantment)this);
        if (level <= 0) {
            return;
        }
        LivingEntity target = event.getEntity();
        if (!(target instanceof LivingEntity)) {
            return;
        }
        LivingEntity hitMob = target;
        Level level2 = user.m_9236_();
        if (level2 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level2;
            double radius = 10.0;
            List nearbyMobs = serverLevel.m_6443_(LivingEntity.class, hitMob.m_20191_().m_82400_(radius), mob -> mob != hitMob && mob != user);
            int ricochetArrows = Math.min(level, nearbyMobs.size());
            for (int i = 0; i < ricochetArrows; ++i) {
                LivingEntity targetMob = (LivingEntity)nearbyMobs.get(i);
                Arrow ricochetArrow = new Arrow((Level)serverLevel, hitMob.m_20185_(), hitMob.m_20186_() + (double)hitMob.m_20192_() / 2.0, hitMob.m_20189_());
                ricochetArrow.m_5602_((Entity)user);
                ricochetArrow.m_36781_(arrow.m_36789_());
                ricochetArrow.m_36735_(arrow.m_150123_());
                ricochetArrow.m_36762_(arrow.m_36792_());
                ricochetArrow.m_20254_(arrow.m_20094_() / 20);
                double dx = targetMob.m_20185_() - ricochetArrow.m_20185_();
                double dy = targetMob.m_20186_() + (double)targetMob.m_20192_() / 2.0 - ricochetArrow.m_20186_();
                double dz = targetMob.m_20189_() - ricochetArrow.m_20189_();
                double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
                double accuracy = 0.1 + 0.2 * (double)level;
                double inaccuracy = 1.0 - accuracy;
                ricochetArrow.m_20334_(dx / distance + user.m_217043_().m_188583_() * inaccuracy, dy / distance + user.m_217043_().m_188583_() * inaccuracy, dz / distance + user.m_217043_().m_188583_() * inaccuracy);
                serverLevel.m_7967_((Entity)ricochetArrow);
            }
        }
    }
}

