/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.enchantment;

import java.util.List;
import net.mcreator.redev.init.RedevModEnchantments;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SwashbucklingEnchantment
extends Enchantment {
    public SwashbucklingEnchantment(EquipmentSlot ... slots) {
        super(Enchantment.Rarity.UNCOMMON, EnchantmentCategory.WEAPON, slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public int m_6586_() {
        return 5;
    }

    protected boolean m_5975_(Enchantment ench) {
        return this != ench && !List.of(Enchantments.f_44977_, Enchantments.f_44978_, Enchantments.f_44979_, (Enchantment)RedevModEnchantments.ILLAGER_BANE.get()).contains(ench);
    }

    public boolean canApplyAtEnchantingTable(ItemStack itemstack) {
        return Ingredient.m_204132_((TagKey)ItemTags.create((ResourceLocation)new ResourceLocation("redev:cutlasses"))).test(itemstack);
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)entity;
        ItemStack weapon = attacker.m_21205_();
        int level = weapon.getEnchantmentLevel((Enchantment)this);
        if (level <= 0) {
            return;
        }
        LivingEntity target = event.getEntity();
        if (this.isAquaticMob(target) || this.isSubmergedInWater(target)) {
            float bonusDamage = (float)(1.5 * (double)level);
            event.setAmount(event.getAmount() + bonusDamage);
        }
    }

    private boolean isAquaticMob(LivingEntity entity) {
        return entity.m_6095_().m_20674_() == MobCategory.WATER_CREATURE;
    }

    private boolean isSubmergedInWater(LivingEntity entity) {
        return entity.m_20069_();
    }
}

