/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.enchantment;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class WaterweightEnchantment
extends Enchantment {
    public WaterweightEnchantment(EquipmentSlot ... slots) {
        super(Enchantment.Rarity.UNCOMMON, EnchantmentCategory.DIGGER, slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public int m_6586_() {
        return 3;
    }

    public boolean canApplyAtEnchantingTable(ItemStack itemstack) {
        return Ingredient.m_204132_((TagKey)ItemTags.create((ResourceLocation)new ResourceLocation("redev:anchors"))).test(itemstack);
    }

    @SubscribeEvent
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (!event.getEntity().m_5842_()) {
            return;
        }
        ItemStack tool = event.getEntity().m_21205_();
        int level = tool.getEnchantmentLevel((Enchantment)this);
        if (level <= 0) {
            return;
        }
        float speedMultiplier = 1.0f + 1.0f * (float)level;
        event.setNewSpeed(event.getOriginalSpeed() * speedMultiplier);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (!event.player.m_5842_()) {
            return;
        }
        ItemStack tool = event.player.m_21205_();
        int level = tool.getEnchantmentLevel((Enchantment)this);
        if (level <= 0) {
            return;
        }
        event.player.m_20256_(event.player.m_20184_().m_82520_(0.0, -0.015 * (double)level, 0.0));
    }
}

