/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.entity;

import java.util.ArrayList;
import java.util.List;
import net.mcreator.redev.init.RedevModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class CopperGolemEntity
extends AbstractGolem {
    private BlockPos targetInteractPos = null;
    private BlockPos markedInteractPos = null;
    private int buttonCooldown = 0;
    private int rotationCooldown = 0;
    private int rotationDuration = 0;
    private static final EntityDataAccessor<Integer> DATA_IS_INTERACTING = SynchedEntityData.m_135353_(CopperGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_IS_WAXED = SynchedEntityData.m_135353_(CopperGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_OXIDIZATION_LEVEL = SynchedEntityData.m_135353_(CopperGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public CopperGolemEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<CopperGolemEntity>)((EntityType)RedevModEntities.COPPER_GOLEM.get()), world);
    }

    public CopperGolemEntity(EntityType<CopperGolemEntity> type, Level world) {
        super(type, world);
        this.m_274367_(0.6f);
        this.f_21364_ = 0;
        if (!this.m_21525_()) {
            this.m_21557_(false);
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        if (this.getOxidizationLevel() < 4) {
            this.f_21345_.m_25352_(1, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
            this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundGoal((Mob)this));
            this.f_21345_.m_25352_(3, (Goal)new FloatGoal((Mob)this));
            this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
            this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Villager.class, 6.0f));
            this.f_21345_.m_25352_(6, (Goal)new AvoidEntityGoal((PathfinderMob)this, Monster.class, 6.0f, 1.0, 1.2));
            this.f_21345_.m_25352_(7, (Goal)new FindAndInteractGoal(this));
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.rotationCooldown > 0) {
            --this.rotationCooldown;
        }
        if (this.rotationCooldown <= 0 && this.f_19796_.m_188503_(100) < 2) {
            this.rotationCooldown = 20 * (5 + this.f_19796_.m_188503_(8));
            switch (this.getOxidizationLevel()) {
                case 1: {
                    int n = 40;
                    break;
                }
                case 2: {
                    int n = 60;
                    break;
                }
                case 3: {
                    int n = 80;
                    break;
                }
                case 4: {
                    int n = 100;
                    break;
                }
                default: {
                    int n = this.rotationDuration = 40;
                }
            }
        }
        if (this.rotationDuration > 0) {
            --this.rotationDuration;
        }
        if (!this.isWaxed() && this.f_19796_.m_188503_(6000) == 0 && this.getOxidizationLevel() < 4) {
            this.setOxidizationLevel(this.getOxidizationLevel() + 1);
        }
        if (this.getOxidizationLevel() == 4 && !this.m_21525_()) {
            this.m_21557_(true);
        }
        if (this.getIsInteracting() > 0) {
            this.setIsInteracting(this.getIsInteracting() - 1);
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_41720_() instanceof AxeItem) {
            if (this.isWaxed()) {
                this.setWaxed(false);
                this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11964_, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.emitWaxOffParticles();
                return InteractionResult.SUCCESS;
            }
            if (this.getOxidizationLevel() > 1) {
                this.setOxidizationLevel(this.getOxidizationLevel() - 1);
                this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_144059_, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.emitScrapeParticles();
                return InteractionResult.SUCCESS;
            }
        } else if (itemStack.m_150930_(Items.f_42784_) && !this.isWaxed()) {
            this.setWaxed(true);
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_144178_, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.emitWaxOnParticles();
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    private void emitWaxOffParticles() {
        for (int i = 0; i < 10; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175829_, this.m_20208_(0.7), this.m_20187_(), this.m_20262_(0.7), 0.0, 0.0, 0.0);
        }
    }

    private void emitScrapeParticles() {
        for (int i = 0; i < 10; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175831_, this.m_20208_(0.7), this.m_20187_(), this.m_20262_(0.7), 0.0, 0.0, 0.0);
        }
    }

    private void emitWaxOnParticles() {
        for (int i = 0; i < 10; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175828_, this.m_20208_(0.7), this.m_20187_(), this.m_20262_(0.7), 0.0, 0.0, 0.0);
        }
    }

    public void m_8038_(ServerLevel serverLevel, LightningBolt lightning) {
        super.m_8038_(serverLevel, lightning);
        BlockPos golemPos = this.m_20183_();
        int radius = 5;
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)golemPos.m_7918_(-radius, -radius, -radius), (BlockPos)golemPos.m_7918_(radius, radius, radius))) {
            if (!serverLevel.m_8055_(pos).m_60713_(Blocks.f_50083_)) continue;
            serverLevel.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        }
        double damageRadius = 5.0;
        List nearbyMobs = serverLevel.m_6443_(Mob.class, this.m_20191_().m_82400_(damageRadius), mob -> !(mob instanceof CopperGolemEntity));
        for (Mob mob2 : nearbyMobs) {
            mob2.m_6469_(new DamageSource((Holder)serverLevel.m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268450_)), 3.0f);
        }
        this.setOxidizationLevel(1);
        this.updateMovementSpeed();
        this.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 3600, 1));
        serverLevel.m_5594_(null, this.m_20183_(), SoundEvents.f_12090_, SoundSource.NEUTRAL, 1.0f, 1.0f);
    }

    public boolean m_6469_(DamageSource damagesource, float amount) {
        if (damagesource.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268722_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268631_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268434_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268468_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268450_)) {
            return false;
        }
        return super.m_6469_(damagesource, amount);
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHitIn) {
        super.m_7472_(source, looting, recentlyHitIn);
        this.m_19983_(new ItemStack((ItemLike)Blocks.f_152504_));
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_IS_INTERACTING, (Object)0);
        this.f_19804_.m_135372_(DATA_OXIDIZATION_LEVEL, (Object)1);
        this.f_19804_.m_135372_(DATA_IS_WAXED, (Object)false);
        super.m_8097_();
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setOxidizationLevel(tag.m_128451_("OxidizationLevel"));
        this.setWaxed(tag.m_128471_("IsWaxed"));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("OxidizationLevel", this.getOxidizationLevel());
        tag.m_128379_("IsWaxed", this.isWaxed());
    }

    public int getOxidizationLevel() {
        return (Integer)this.f_19804_.m_135370_(DATA_OXIDIZATION_LEVEL);
    }

    public void setOxidizationLevel(int level) {
        level = Math.max(1, Math.min(level, 4));
        this.f_19804_.m_135381_(DATA_OXIDIZATION_LEVEL, (Object)level);
        this.updateMovementSpeed();
    }

    public boolean isWaxed() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_WAXED);
    }

    public void setWaxed(boolean waxed) {
        this.f_19804_.m_135381_(DATA_IS_WAXED, (Object)waxed);
    }

    public int getIsInteracting() {
        return (Integer)this.f_19804_.m_135370_(DATA_IS_INTERACTING);
    }

    public void setIsInteracting(int value) {
        this.f_19804_.m_135381_(DATA_IS_INTERACTING, (Object)value);
    }

    public int getTotalRotationDuration() {
        return this.rotationDuration;
    }

    private void updateMovementSpeed() {
        double baseSpeed = 0.2;
        double speedFactor = 1.0 - (double)(this.getOxidizationLevel() - 1) * 0.25;
        double adjustedSpeed = baseSpeed * Math.max(speedFactor, 0.0);
        this.m_21051_(Attributes.f_22279_).m_22100_(adjustedSpeed);
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.copper.hit"));
    }

    public void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.copper.step")), 0.15f, 1.0f);
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.armor_stand.hit"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.armor_stand.break"));
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.2);
        builder = builder.m_22268_(Attributes.f_22276_, 15.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.1);
        builder = builder.m_22268_(Attributes.f_22281_, 0.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        builder = builder.m_22268_(Attributes.f_22278_, 0.2);
        return builder;
    }

    class FindAndInteractGoal
    extends Goal {
        private final CopperGolemEntity golem;
        private BlockPos interactablePos;

        public FindAndInteractGoal(CopperGolemEntity golem) {
            this.golem = golem;
        }

        public boolean m_8036_() {
            if (this.golem.buttonCooldown > 0) {
                --this.golem.buttonCooldown;
                return false;
            }
            this.interactablePos = this.findNearestInteractable();
            return this.interactablePos != null;
        }

        public void m_8056_() {
            if (this.interactablePos != null) {
                this.golem.m_21573_().m_26519_((double)this.interactablePos.m_123341_() + 0.5, (double)this.interactablePos.m_123342_() + 0.5, (double)this.interactablePos.m_123343_() + 0.5, 1.0);
                this.golem.targetInteractPos = this.interactablePos;
            }
        }

        public void m_8037_() {
            if (this.golem.targetInteractPos != null && this.golem.m_20183_().m_123314_((Vec3i)this.golem.targetInteractPos, 1.5)) {
                this.interactWithBlock(this.golem.targetInteractPos);
                if (this.golem.markedInteractPos != null) {
                    this.unmarkBlock(this.golem.markedInteractPos);
                }
                this.golem.markedInteractPos = this.golem.targetInteractPos;
                this.golem.targetInteractPos = null;
                this.golem.buttonCooldown = 60;
            }
        }

        public boolean m_8045_() {
            return this.golem.targetInteractPos != null && !this.golem.m_21573_().m_26571_();
        }

        private BlockPos findNearestInteractable() {
            List<BlockPos> interactables = this.findInteractablesInRadius(5);
            if (interactables.isEmpty()) {
                return null;
            }
            if (this.golem.markedInteractPos != null && (this.golem.f_19796_.m_188500_() < 0.3 || interactables.size() == 1)) {
                return this.golem.markedInteractPos;
            }
            interactables.remove(this.golem.markedInteractPos);
            return interactables.isEmpty() ? this.golem.markedInteractPos : interactables.get(this.golem.f_19796_.m_188503_(interactables.size()));
        }

        private List<BlockPos> findInteractablesInRadius(int radius) {
            ArrayList<BlockPos> interactables = new ArrayList<BlockPos>();
            BlockPos currentPos = this.golem.m_20183_();
            for (int x = -radius; x <= radius; ++x) {
                for (int y = -radius; y <= radius; ++y) {
                    for (int z = -radius; z <= radius; ++z) {
                        BlockPos pos = currentPos.m_7918_(x, y, z);
                        BlockState state = this.golem.m_9236_().m_8055_(pos);
                        if (!(state.m_60734_() instanceof ButtonBlock) && state.m_60734_() != Blocks.f_50164_) continue;
                        interactables.add(pos);
                    }
                }
            }
            return interactables;
        }

        private void interactWithBlock(BlockPos blockPos) {
            BlockState state = this.golem.m_9236_().m_8055_(blockPos);
            Block block = state.m_60734_();
            if (block instanceof ButtonBlock) {
                ButtonBlock button = (ButtonBlock)block;
                button.m_51116_(state, this.golem.m_9236_(), blockPos);
                this.golem.setIsInteracting(40);
                this.golem.m_9236_().m_5594_(null, blockPos, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("minecraft:block.stone_button.click_on")), SoundSource.BLOCKS, 1.0f, 1.0f);
            } else if (state.m_60734_() == Blocks.f_50164_) {
                boolean powered = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_);
                this.golem.setIsInteracting(20);
                this.golem.m_9236_().m_46597_(blockPos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(!powered)));
                this.golem.m_9236_().m_5594_(null, blockPos, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("minecraft:block.lever.click")), SoundSource.BLOCKS, 1.0f, powered ? 0.6f : 0.5f);
            }
        }

        private void unmarkBlock(BlockPos blockPos) {
        }
    }
}

